/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.policy;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.policy.DefaultPolicyInstance;
import org.mule.runtime.core.policy.Policy;
import org.mule.runtime.core.policy.PolicyInstance;
import org.mule.runtime.core.policy.PolicyParametrization;
import org.mule.runtime.core.policy.PolicyPointcut;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContext;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPlugin;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplate;
import org.mule.runtime.module.artifact.classloader.ClassLoaderRepository;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactContextBuilder;
import org.mule.runtime.module.deployment.impl.internal.artifact.CompositeArtifactExtensionManagerFactory;
import org.mule.runtime.module.deployment.impl.internal.policy.ApplicationPolicyInstance;
import org.mule.runtime.module.extension.internal.loader.ExtensionModelLoaderRepository;
import org.mule.runtime.module.extension.internal.manager.DefaultExtensionManagerFactory;
import org.mule.runtime.module.service.ServiceRepository;

public class DefaultApplicationPolicyInstance
implements ApplicationPolicyInstance {
    private final Application application;
    private final PolicyTemplate template;
    private final PolicyParametrization parametrization;
    private final ServiceRepository serviceRepository;
    private final ClassLoaderRepository classLoaderRepository;
    private final List<ArtifactPlugin> artifactPlugins;
    private final ExtensionModelLoaderRepository extensionModelLoaderRepository;
    private ArtifactContext policyContext;
    private PolicyInstance policyInstance;

    public DefaultApplicationPolicyInstance(Application application, PolicyTemplate template, PolicyParametrization parametrization, ServiceRepository serviceRepository, ClassLoaderRepository classLoaderRepository, List<ArtifactPlugin> artifactPlugins, ExtensionModelLoaderRepository extensionModelLoaderRepository) {
        this.application = application;
        this.template = template;
        this.parametrization = parametrization;
        this.serviceRepository = serviceRepository;
        this.classLoaderRepository = classLoaderRepository;
        this.artifactPlugins = artifactPlugins;
        this.extensionModelLoaderRepository = extensionModelLoaderRepository;
    }

    private void initPolicyContext() throws InitialisationException {
        ArtifactContextBuilder artifactBuilder = ArtifactContextBuilder.newBuilder().setArtifactType(ArtifactType.APP).setArtifactProperties(new HashMap<String, String>(this.parametrization.getParameters())).setArtifactName(this.parametrization.getId()).setConfigurationFiles(this.parametrization.getConfig().getAbsolutePath()).setExecutionClassloader(this.template.getArtifactClassLoader().getClassLoader()).setServiceRepository(this.serviceRepository).setClassLoaderRepository(this.classLoaderRepository).setArtifactPlugins(this.artifactPlugins).setExtensionManagerFactory(new CompositeArtifactExtensionManagerFactory(this.application, this.extensionModelLoaderRepository, this.artifactPlugins, new DefaultExtensionManagerFactory()));
        artifactBuilder.withServiceConfigurator(customizationService -> customizationService.overrideDefaultServiceImpl("_mulePolicyStateHandler", this.application.getMuleContext().getRegistry().lookupObject("_mulePolicyStateHandler")));
        try {
            this.policyContext = artifactBuilder.build();
            this.policyContext.getMuleContext().start();
        }
        catch (MuleException e) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage("Cannot create artifact context for the policy instance"), (Throwable)e, this);
        }
    }

    private void initPolicyInstance() throws InitialisationException {
        try {
            this.policyInstance = this.policyContext.getMuleContext().getRegistry().lookupObject(DefaultPolicyInstance.class);
        }
        catch (RegistrationException e) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage(String.format("More than one %s found on context", ApplicationPolicyInstance.class)), (Throwable)e, this);
        }
        try {
            this.policyInstance.initialise();
            this.policyInstance.start();
        }
        catch (Exception e) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage("Unable to apply lifecycle to policy instance"), (Throwable)e, this);
        }
    }

    @Override
    public PolicyPointcut getPointcut() {
        return this.parametrization.getPointcut();
    }

    @Override
    public int getOrder() {
        return this.parametrization.getOrder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialise() throws InitialisationException {
        if (this.policyInstance == null) {
            DefaultApplicationPolicyInstance defaultApplicationPolicyInstance = this;
            synchronized (defaultApplicationPolicyInstance) {
                if (this.policyContext == null) {
                    this.initPolicyContext();
                }
                this.initPolicyInstance();
            }
        }
    }

    @Override
    public void dispose() {
        if (this.policyContext != null) {
            this.policyContext.getMuleContext().dispose();
        }
    }

    @Override
    public Optional<Policy> getSourcePolicy() {
        if (this.policyInstance.getSourcePolicyChain().isPresent()) {
            return Optional.of(new Policy(this.policyInstance.getSourcePolicyChain().get(), this.parametrization.getId()));
        }
        return Optional.empty();
    }

    @Override
    public Optional<Policy> getOperationPolicy() {
        if (this.policyInstance.getOperationPolicyChain().isPresent()) {
            return Optional.of(new Policy(this.policyInstance.getOperationPolicyChain().get(), this.parametrization.getId()));
        }
        return Optional.empty();
    }
}

