/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.policy;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MulePolicyModel;
import org.mule.runtime.api.deployment.persistence.MulePolicyModelJsonSerializer;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.registry.SpiServiceRegistry;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplateDescriptor;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptorCreateException;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.descriptor.BundleDescriptorLoader;
import org.mule.runtime.module.artifact.descriptor.ClassLoaderModel;
import org.mule.runtime.module.artifact.descriptor.ClassLoaderModelLoader;
import org.mule.runtime.module.artifact.descriptor.InvalidDescriptorLoaderException;
import org.mule.runtime.module.deployment.impl.internal.artifact.DescriptorLoaderRepository;
import org.mule.runtime.module.deployment.impl.internal.artifact.LoaderNotFoundException;
import org.mule.runtime.module.deployment.impl.internal.artifact.ServiceRegistryDescriptorLoaderRepository;
import org.mule.runtime.module.deployment.impl.internal.plugin.ArtifactPluginDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.plugin.ArtifactPluginDescriptorLoader;

public class PolicyTemplateDescriptorFactory
implements ArtifactDescriptorFactory<PolicyTemplateDescriptor> {
    protected static final String MISSING_POLICY_DESCRIPTOR_ERROR = "Policy must contain a mule-policy.json file";
    private final ArtifactPluginDescriptorLoader artifactPluginDescriptorLoader;
    private final DescriptorLoaderRepository descriptorLoaderRepository;

    public PolicyTemplateDescriptorFactory() {
        this(new ArtifactPluginDescriptorLoader(new ArtifactPluginDescriptorFactory()), new ServiceRegistryDescriptorLoaderRepository(new SpiServiceRegistry()));
    }

    public PolicyTemplateDescriptorFactory(ArtifactPluginDescriptorLoader artifactPluginDescriptorLoader, DescriptorLoaderRepository descriptorLoaderRepository) {
        Preconditions.checkArgument(artifactPluginDescriptorLoader != null, "artifactPluginDescriptorLoader cannot be null");
        Preconditions.checkArgument(descriptorLoaderRepository != null, "descriptorLoaderRepository cannot be null");
        this.artifactPluginDescriptorLoader = artifactPluginDescriptorLoader;
        this.descriptorLoaderRepository = descriptorLoaderRepository;
    }

    @Override
    public PolicyTemplateDescriptor create(File artifactFolder) throws ArtifactDescriptorCreateException {
        File policyJsonFile = new File(artifactFolder, "META-INF" + File.separator + "mule-artifact" + File.separator + "mule-policy.json");
        if (!policyJsonFile.exists()) {
            throw new ArtifactDescriptorCreateException(MISSING_POLICY_DESCRIPTOR_ERROR);
        }
        MulePolicyModel mulePolicyModel = this.getMulePolicyJsonDescriber(policyJsonFile);
        PolicyTemplateDescriptor descriptor = new PolicyTemplateDescriptor(mulePolicyModel.getName());
        descriptor.setRootFolder(artifactFolder);
        if (mulePolicyModel.getClassLoaderModelLoaderDescriptor().isPresent()) {
            descriptor.setClassLoaderModel(this.getClassLoaderModel(artifactFolder, mulePolicyModel));
        }
        descriptor.setBundleDescriptor(this.getBundleDescriptor(artifactFolder, mulePolicyModel));
        descriptor.setPlugins(this.parseArtifactPluginDescriptors(descriptor));
        return descriptor;
    }

    private BundleDescriptor getBundleDescriptor(File artifactFolder, MulePolicyModel mulePolicyModel) {
        BundleDescriptorLoader bundleDescriptorLoader;
        try {
            bundleDescriptorLoader = this.descriptorLoaderRepository.get(mulePolicyModel.getBundleDescriptorLoader().getId(), ArtifactType.POLICY, BundleDescriptorLoader.class);
        }
        catch (LoaderNotFoundException e) {
            throw new ArtifactDescriptorCreateException(PolicyTemplateDescriptorFactory.invalidBundleDescriptorLoaderIdError(mulePolicyModel.getBundleDescriptorLoader()));
        }
        try {
            return (BundleDescriptor)bundleDescriptorLoader.load(artifactFolder, mulePolicyModel.getBundleDescriptorLoader().getAttributes(), ArtifactType.POLICY);
        }
        catch (InvalidDescriptorLoaderException e) {
            throw new ArtifactDescriptorCreateException(e);
        }
    }

    private ClassLoaderModel getClassLoaderModel(File artifactFolder, MulePolicyModel mulePolicyModel) {
        ClassLoaderModelLoader classLoaderModelLoader;
        MuleArtifactLoaderDescriptor muleArtifactLoaderDescriptor = mulePolicyModel.getClassLoaderModelLoaderDescriptor().get();
        try {
            classLoaderModelLoader = this.descriptorLoaderRepository.get(muleArtifactLoaderDescriptor.getId(), ArtifactType.POLICY, ClassLoaderModelLoader.class);
        }
        catch (LoaderNotFoundException e) {
            throw new ArtifactDescriptorCreateException(PolicyTemplateDescriptorFactory.invalidClassLoaderModelIdError(muleArtifactLoaderDescriptor));
        }
        try {
            return (ClassLoaderModel)classLoaderModelLoader.load(artifactFolder, mulePolicyModel.getClassLoaderModelLoaderDescriptor().get().getAttributes(), ArtifactType.POLICY);
        }
        catch (InvalidDescriptorLoaderException e) {
            throw new ArtifactDescriptorCreateException(e);
        }
    }

    protected static String invalidBundleDescriptorLoaderIdError(MuleArtifactLoaderDescriptor bundleDescriptorLoader) {
        return "Unknown bundle descriptor loader: " + bundleDescriptorLoader.getId();
    }

    protected static String invalidClassLoaderModelIdError(MuleArtifactLoaderDescriptor muleArtifactLoaderDescriptor) {
        return "Unknown model loader: " + muleArtifactLoaderDescriptor.getId();
    }

    private Set<ArtifactPluginDescriptor> parseArtifactPluginDescriptors(PolicyTemplateDescriptor descriptor) {
        Set pluginDependencies = descriptor.getClassLoaderModel().getDependencies().stream().filter(dependency -> dependency.getDescriptor().isPlugin()).collect(Collectors.toSet());
        return pluginDependencies.stream().map(dependency -> {
            try {
                return this.artifactPluginDescriptorLoader.load(new File(dependency.getBundleUri()));
            }
            catch (IOException e) {
                throw new MuleRuntimeException(e);
            }
        }).collect(Collectors.toSet());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MulePolicyModel getMulePolicyJsonDescriber(File jsonFile) {
        try (FileInputStream stream = new FileInputStream(jsonFile);){
            MulePolicyModel mulePolicyModel = (MulePolicyModel)new MulePolicyModelJsonSerializer().deserialize(IOUtils.toString((InputStream)stream));
            return mulePolicyModel;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Could not read extension describer on plugin '%s'", jsonFile.getAbsolutePath()), e);
        }
    }
}

