/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactFactory;
import org.mule.runtime.module.deployment.internal.ArchiveDeployer;
import org.mule.runtime.module.deployment.internal.CompositeDeploymentListener;
import org.mule.runtime.module.reboot.api.MuleContainerBootstrapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainArchiveDeployer
implements ArchiveDeployer<Domain> {
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String DOMAIN_BUNDLE_APPS_FOLDER = "apps";
    private final ArchiveDeployer<Domain> domainDeployer;
    private final DeploymentService deploymentService;
    private final ArchiveDeployer<Application> applicationDeployer;

    public DomainArchiveDeployer(ArchiveDeployer<Domain> domainDeployer, ArchiveDeployer<Application> applicationDeployer, DeploymentService deploymentService) {
        this.domainDeployer = domainDeployer;
        this.applicationDeployer = applicationDeployer;
        this.deploymentService = deploymentService;
    }

    @Override
    public boolean isUpdatedZombieArtifact(String artifactName) {
        return true;
    }

    @Override
    public Domain deployPackagedArtifact(String zip) throws DeploymentException {
        Domain domain = this.domainDeployer.deployPackagedArtifact(zip);
        this.deployBundledAppsIfDomainWasCreated(domain);
        return domain;
    }

    @Override
    public Domain deployExplodedArtifact(String artifactDir) throws DeploymentException {
        Domain domain = this.domainDeployer.deployExplodedArtifact(artifactDir);
        this.deployBundledAppsIfDomainWasCreated(domain);
        return domain;
    }

    @Override
    public Domain deployPackagedArtifact(URI artifactAchivedUrl) {
        Domain domain = this.domainDeployer.deployPackagedArtifact(artifactAchivedUrl);
        this.deployBundledAppsIfDomainWasCreated(domain);
        return domain;
    }

    @Override
    public void undeployArtifact(String artifactId) {
        Collection<Application> domainApplications = this.findApplicationsAssociated(artifactId);
        for (Application domainApplication : domainApplications) {
            this.applicationDeployer.undeployArtifact(domainApplication.getArtifactName());
        }
        this.domainDeployer.undeployArtifact(artifactId);
    }

    private Collection<Application> findApplicationsAssociated(String artifactId) {
        Domain domain = this.deploymentService.findDomain(artifactId);
        Preconditions.checkArgument(domain != null, String.format("Domain %s does not exists", artifactId));
        return this.findApplicationsAssociated(domain);
    }

    private Collection<Application> findApplicationsAssociated(Domain domain) {
        return this.deploymentService.findDomainApplications(domain.getArtifactName());
    }

    @Override
    public File getDeploymentDirectory() {
        return this.domainDeployer.getDeploymentDirectory();
    }

    @Override
    public void setDeploymentListener(CompositeDeploymentListener deploymentListener) {
        this.domainDeployer.setDeploymentListener(deploymentListener);
    }

    @Override
    public void redeploy(Domain artifact) throws DeploymentException {
        Collection<Application> domainApplications = this.findApplicationsAssociated(artifact);
        for (Application domainApplication : domainApplications) {
            this.applicationDeployer.undeployArtifactWithoutUninstall(domainApplication);
        }
        try {
            this.domainDeployer.redeploy(artifact);
        }
        catch (DeploymentException e) {
            this.logger.warn(String.format("Failure during redeployment of domain %s, domain applications deployment will be skipped", artifact.getArtifactName()));
            throw e;
        }
        for (Application domainApplication : domainApplications) {
            try {
                this.applicationDeployer.redeploy(domainApplication);
            }
            catch (Exception e) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Error redeploying application {}", (Object)domainApplication.getArtifactName(), (Object)e);
            }
        }
    }

    @Override
    public Map<URI, Long> getArtifactsZombieMap() {
        return this.domainDeployer.getArtifactsZombieMap();
    }

    @Override
    public void setArtifactFactory(ArtifactFactory<Domain> artifactFactory) {
        this.domainDeployer.setArtifactFactory(artifactFactory);
    }

    @Override
    public void undeployArtifactWithoutUninstall(Domain artifact) {
        throw new NotImplementedException("undeploy without uninstall is not supported for domains");
    }

    @Override
    public void deployArtifact(Domain artifact) {
        this.domainDeployer.deployArtifact(artifact);
    }

    private void deployBundledAppsIfDomainWasCreated(Domain domain) {
        if (domain != null) {
            this.deployBundleApps(domain);
        }
    }

    private void deployBundleApps(Domain domain) {
        File domainFolder = new File(this.domainDeployer.getDeploymentDirectory(), domain.getArtifactName());
        File appsFolder = new File(domainFolder, DOMAIN_BUNDLE_APPS_FOLDER);
        if (appsFolder.exists()) {
            File[] files;
            for (File file : files = appsFolder.listFiles((dir, name) -> name.endsWith(".jar"))) {
                try {
                    FileUtils.moveFile((File)file, (File)new File(MuleContainerBootstrapUtils.getMuleAppsDir(), file.getName()));
                }
                catch (IOException e) {
                    this.logger.warn(e.getMessage());
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("Cannot move file {} to apps folder", (Object)file, (Object)e);
                }
            }
        }
    }
}

