/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl.source;

import java.util.List;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.streaming.CursorProviderFactory;
import org.mule.runtime.dsl.api.component.AttributeDefinition;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.TypeDefinition;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.module.extension.internal.config.dsl.ExtensionDefinitionParser;
import org.mule.runtime.module.extension.internal.config.dsl.ExtensionParsingContext;
import org.mule.runtime.module.extension.internal.config.dsl.source.ExtensionSourceObjectFactory;
import org.mule.runtime.module.extension.internal.runtime.source.ExtensionMessageSource;

public class SourceDefinitionParser
extends ExtensionDefinitionParser {
    private final ExtensionModel extensionModel;
    private final SourceModel sourceModel;
    private final DslElementSyntax sourceDsl;

    public SourceDefinitionParser(ComponentBuildingDefinition.Builder definition, ExtensionModel extensionModel, SourceModel sourceModel, DslSyntaxResolver dslSyntaxResolver, ExtensionParsingContext parsingContext) {
        super(definition, dslSyntaxResolver, parsingContext);
        this.extensionModel = extensionModel;
        this.sourceModel = sourceModel;
        this.sourceDsl = dslSyntaxResolver.resolve(sourceModel);
    }

    @Override
    protected void doParse(ComponentBuildingDefinition.Builder definitionBuilder) throws ConfigurationException {
        definitionBuilder.withIdentifier(this.sourceDsl.getElementName()).withTypeDefinition(TypeDefinition.fromType(ExtensionMessageSource.class)).withObjectFactoryType(ExtensionSourceObjectFactory.class).withConstructorParameterDefinition(AttributeDefinition.Builder.fromFixedValue(this.extensionModel).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromFixedValue(this.sourceModel).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromReferenceObject(MuleContext.class).build()).withSetterParameterDefinition("retryPolicyTemplate", AttributeDefinition.Builder.fromChildConfiguration(RetryPolicyTemplate.class).build()).withSetterParameterDefinition("configurationProvider", AttributeDefinition.Builder.fromSimpleReferenceParameter("config-ref").build()).withSetterParameterDefinition("cursorProviderFactory", AttributeDefinition.Builder.fromChildConfiguration(CursorProviderFactory.class).build());
        List<ParameterGroupModel> inlineGroups = this.getInlineGroups(this.sourceModel);
        this.sourceModel.getErrorCallback().ifPresent(cb -> inlineGroups.addAll(this.getInlineGroups((ParameterizedModel)cb)));
        this.sourceModel.getSuccessCallback().ifPresent(cb -> inlineGroups.addAll(this.getInlineGroups((ParameterizedModel)cb)));
        this.parseParameters(this.getFlatParameters(inlineGroups, this.sourceModel.getAllParameterModels()));
        for (ParameterGroupModel group : inlineGroups) {
            this.parseInlineParameterGroup(group);
        }
    }
}

