/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.core.api.util.collection.Collectors;
import org.mule.runtime.extension.api.annotation.SubTypeMapping;
import org.mule.runtime.extension.api.annotation.SubTypesMapping;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.internal.loader.enricher.AbstractAnnotatedDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public final class SubTypesDeclarationEnricher
extends AbstractAnnotatedDeclarationEnricher {
    private ClassTypeLoader typeLoader;

    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        ExtensionDeclarer declarer = extensionLoadingContext.getExtensionDeclarer();
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)declarer.getDeclaration();
        Optional<ImplementingTypeModelProperty> implementingType = this.extractImplementingTypeProperty(extensionDeclaration);
        if (!implementingType.isPresent()) {
            return;
        }
        Class<?> type = implementingType.get().getType();
        this.typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(type.getClassLoader());
        List<SubTypeMapping> typeMappings = MuleExtensionAnnotationParser.parseRepeatableAnnotation(type, SubTypeMapping.class, c -> ((SubTypesMapping)c).value());
        if (!typeMappings.isEmpty()) {
            this.declareSubTypesMapping(declarer, typeMappings, extensionDeclaration.getName());
        }
    }

    private void declareSubTypesMapping(ExtensionDeclarer declarer, List<SubTypeMapping> typeMappings, String name) {
        if (typeMappings.stream().map(SubTypeMapping::baseType).distinct().collect(java.util.stream.Collectors.toList()).size() != typeMappings.size()) {
            throw new IllegalModelDefinitionException(String.format("There should be only one SubtypeMapping for any given base type in extension [%s]. Duplicated base types are not allowed", name));
        }
        typeMappings.forEach(mapping -> declarer.withSubTypes(IntrospectionUtils.getMetadataType(mapping.baseType(), this.typeLoader), Arrays.stream(mapping.subTypes()).map(subType -> IntrospectionUtils.getMetadataType(subType, this.typeLoader)).collect(Collectors.toImmutableList())));
    }
}

