/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyProvider;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataProvider;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.resolving.ExtensionResolvingContext;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.values.Value;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.TemplateParser;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.core.internal.metadata.DefaultMetadataContext;
import org.mule.runtime.core.internal.metadata.MuleMetadataService;
import org.mule.runtime.core.internal.resolving.DefaultExtensionResolvingContext;
import org.mule.runtime.core.streaming.CursorProviderFactory;
import org.mule.runtime.core.streaming.StreamingManager;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.runtime.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.ConfigurationProvider;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.extension.api.values.ComponentValuesProvider;
import org.mule.runtime.extension.api.values.ValueResolvingException;
import org.mule.runtime.extension.internal.property.PagedOperationModelProperty;
import org.mule.runtime.module.extension.internal.metadata.MetadataMediator;
import org.mule.runtime.module.extension.internal.runtime.config.DynamicConfigurationProvider;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.values.ValuesProviderMediator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtensionComponent<T extends ComponentModel>
extends AbstractAnnotatedObject
implements MuleContextAware,
MetadataKeyProvider,
MetadataProvider<T>,
ComponentValuesProvider,
FlowConstructAware,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionComponent.class);
    protected final ExtensionManager extensionManager;
    private final TemplateParser expressionParser = TemplateParser.createMuleStyleParser();
    private final ExtensionModel extensionModel;
    private final T componentModel;
    private final AtomicReference<ConfigurationProvider> configurationProvider = new AtomicReference();
    private final MetadataMediator<T> metadataMediator;
    private final ValuesProviderMediator<T> valuesProviderMediator;
    private final ClassTypeLoader typeLoader;
    private final LazyValue<Boolean> requiresConfig = new LazyValue<Supplier<Boolean>>(this::computeRequiresConfig);
    protected final ClassLoader classLoader;
    private CursorProviderFactory cursorProviderFactory;
    protected FlowConstruct flowConstruct;
    protected MuleContext muleContext;
    @Inject
    protected ConnectionManagerAdapter connectionManager;
    @Inject
    protected StreamingManager streamingManager;
    @Inject
    private MuleMetadataService metadataService;

    protected ExtensionComponent(ExtensionModel extensionModel, T componentModel, ConfigurationProvider configurationProvider, CursorProviderFactory cursorProviderFactory, ExtensionManager extensionManager) {
        this.extensionModel = extensionModel;
        this.classLoader = MuleExtensionUtils.getClassLoader(extensionModel);
        this.componentModel = componentModel;
        this.configurationProvider.set(configurationProvider);
        this.extensionManager = extensionManager;
        this.cursorProviderFactory = cursorProviderFactory;
        this.metadataMediator = new MetadataMediator<T>(componentModel);
        this.valuesProviderMediator = new ValuesProviderMediator<T>(componentModel, this.muleContext);
        this.typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(this.classLoader);
    }

    @Override
    public final void initialise() throws InitialisationException {
        this.valuesProviderMediator.setMuleContext(this.muleContext);
        if (this.cursorProviderFactory == null) {
            this.cursorProviderFactory = this.componentModel.getModelProperty(PagedOperationModelProperty.class).map(p -> this.streamingManager.forObjects().getDefaultCursorProviderFactory()).orElseGet(() -> this.streamingManager.forBytes().getDefaultCursorProviderFactory());
        }
        ClassUtils.withContextClassLoader(this.classLoader, () -> {
            this.validateConfigurationProviderIsNotExpression();
            this.findConfigurationProvider().ifPresent(this::validateOperationConfiguration);
            this.doInitialise();
            return null;
        }, InitialisationException.class, e -> {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        });
    }

    @Override
    public final void start() throws MuleException {
        ClassUtils.withContextClassLoader(this.classLoader, () -> {
            this.doStart();
            return null;
        }, MuleException.class, e -> {
            throw new DefaultMuleException(e);
        });
    }

    @Override
    public final void stop() throws MuleException {
        ClassUtils.withContextClassLoader(this.classLoader, () -> {
            this.doStop();
            return null;
        }, MuleException.class, e -> {
            throw new DefaultMuleException(e);
        });
    }

    @Override
    public final void dispose() {
        try {
            ClassUtils.withContextClassLoader(this.classLoader, () -> {
                this.doDispose();
                return null;
            });
        }
        catch (Exception e) {
            LOGGER.warn("Exception found trying to dispose component", (Throwable)e);
        }
    }

    protected abstract void doInitialise() throws InitialisationException;

    protected abstract void doStart() throws MuleException;

    protected abstract void doStop() throws MuleException;

    protected abstract void doDispose();

    protected abstract void validateOperationConfiguration(ConfigurationProvider var1);

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public MetadataResult<MetadataKeysContainer> getMetadataKeys() throws MetadataResolvingException {
        try {
            return this.runWithMetadataContext(context -> ClassUtils.withContextClassLoader(MuleExtensionUtils.getClassLoader(this.extensionModel), () -> this.metadataMediator.getMetadataKeys((MetadataContext)context)));
        }
        catch (ConnectionException e) {
            return MetadataResult.failure(MetadataFailure.Builder.newFailure(e).onKeys());
        }
    }

    @Override
    public MetadataResult<ComponentMetadataDescriptor<T>> getMetadata() throws MetadataResolvingException {
        try {
            return this.runWithMetadataContext(context -> ClassUtils.withContextClassLoader(this.classLoader, () -> this.metadataMediator.getMetadata((MetadataContext)context, this.getParameterValueResolver())));
        }
        catch (ConnectionException e) {
            return MetadataResult.failure(MetadataFailure.Builder.newFailure(e).onComponent());
        }
    }

    @Override
    public MetadataResult<ComponentMetadataDescriptor<T>> getMetadata(MetadataKey key) throws MetadataResolvingException {
        try {
            return this.runWithMetadataContext(context -> ClassUtils.withContextClassLoader(MuleExtensionUtils.getClassLoader(this.extensionModel), () -> this.metadataMediator.getMetadata((MetadataContext)context, key)));
        }
        catch (ConnectionException e) {
            return MetadataResult.failure(MetadataFailure.Builder.newFailure(e).onComponent());
        }
    }

    @Override
    public Set<Value> getValues(String parameterName) throws ValueResolvingException {
        try {
            return this.runWithValueProvidersContext(context -> ClassUtils.withContextClassLoader(MuleExtensionUtils.getClassLoader(this.extensionModel), () -> this.valuesProviderMediator.getValues(parameterName, this.getParameterValueResolver(), () -> context.getConnection().orElse(null), () -> context.getConfig().orElse(null))));
        }
        catch (ConnectionException e) {
            throw new ValueResolvingException("An error occurred obtaining the connection for the ValueProvider", "CONNECTION_FAILURE", (Throwable)e);
        }
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    protected <R> R runWithMetadataContext(Function<MetadataContext, R> metadataContextFunction) throws MetadataResolvingException, ConnectionException {
        MetadataContext context = this.getMetadataContext();
        R result = metadataContextFunction.apply(context);
        context.dispose();
        return result;
    }

    private <R> R runWithValueProvidersContext(Function<ExtensionResolvingContext, R> metadataContextFunction) throws ValueResolvingException, ConnectionException {
        ExtensionResolvingContext context = this.getResolvingContext();
        R result = metadataContextFunction.apply(context);
        context.dispose();
        return result;
    }

    private MetadataContext getMetadataContext() throws MetadataResolvingException, ConnectionException {
        ConfigurationProvider configurationProvider;
        Event fakeEvent = MuleExtensionUtils.getInitialiserEvent(this.muleContext);
        Optional<ConfigurationInstance> configuration = this.getConfiguration(fakeEvent);
        if (configuration.isPresent() && (configurationProvider = this.findConfigurationProvider().orElseThrow(() -> new MetadataResolvingException("Failed to create the required configuration for Metadata retrieval", FailureCode.INVALID_CONFIGURATION))) instanceof DynamicConfigurationProvider) {
            throw new MetadataResolvingException("Configuration used for Metadata fetch cannot be dynamic", FailureCode.INVALID_CONFIGURATION);
        }
        String cacheId = configuration.map(ConfigurationInstance::getName).orElseGet(() -> this.extensionModel.getName() + "|" + this.componentModel.getName());
        return new DefaultMetadataContext(configuration, this.connectionManager, this.metadataService.getMetadataCache(cacheId), this.typeLoader);
    }

    private ExtensionResolvingContext getResolvingContext() throws ValueResolvingException, ConnectionException {
        Event fakeEvent = MuleExtensionUtils.getInitialiserEvent(this.muleContext);
        Optional<ConfigurationInstance> configuration = this.getConfiguration(fakeEvent);
        return new DefaultExtensionResolvingContext(configuration, this.connectionManager, this.typeLoader);
    }

    protected Optional<ConfigurationInstance> getConfiguration(Event event) {
        if (!this.requiresConfig.get().booleanValue()) {
            return Optional.empty();
        }
        if (this.isConfigurationSpecified()) {
            return Optional.of(this.configurationProvider.get()).map(provider -> Optional.ofNullable(provider.get(event))).orElseThrow(() -> new IllegalModelDefinitionException(String.format("Flow '%s' contains a reference to config '%s' but it doesn't exists", this.flowConstruct.getName(), this.configurationProvider)));
        }
        return this.extensionManager.getConfigurationProvider(this.extensionModel, (ComponentModel)this.componentModel).map(provider -> {
            this.configurationProvider.set((ConfigurationProvider)provider);
            return Optional.ofNullable(provider.get(event));
        }).orElseGet(() -> this.extensionManager.getConfiguration(this.extensionModel, (ComponentModel)this.componentModel, event));
    }

    protected CursorProviderFactory getCursorProviderFactory() {
        return this.cursorProviderFactory;
    }

    private Optional<ConfigurationProvider> findConfigurationProvider() {
        if (this.isConfigurationSpecified()) {
            return Optional.of(this.configurationProvider.get());
        }
        return this.extensionManager.getConfigurationProvider(this.extensionModel, (ComponentModel)this.componentModel);
    }

    private boolean isConfigurationSpecified() {
        return this.configurationProvider.get() != null;
    }

    private boolean computeRequiresConfig() {
        return ExtensionModelUtils.requiresConfig(this.extensionModel, this.componentModel);
    }

    private void validateConfigurationProviderIsNotExpression() throws InitialisationException {
        if (this.isConfigurationSpecified() && this.expressionParser.isContainsTemplate(this.configurationProvider.get().getName())) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage(String.format("Flow '%s' defines component '%s' which specifies the expression '%s' as a config-ref. Expressions are not allowed as config references", this.flowConstruct.getName(), NameUtils.hyphenize(this.componentModel.getName()), this.configurationProvider)), (Initialisable)this);
        }
    }

    protected abstract ParameterValueResolver getParameterValueResolver();

    public ExtensionModel getExtensionModel() {
        return this.extensionModel;
    }
}

