/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKeyProvider;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataKeysContainerBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.api.values.Value;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.internal.connection.ConnectionProviderWrapper;
import org.mule.runtime.core.internal.metadata.DefaultMetadataContext;
import org.mule.runtime.core.internal.metadata.MuleMetadataService;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.runtime.ConfigurationInstance;
import org.mule.runtime.extension.api.values.ConfigurationParameterValuesProvider;
import org.mule.runtime.extension.api.values.ValueResolvingException;
import org.mule.runtime.module.extension.internal.runtime.config.StaticConfigurationProvider;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectBasedParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.values.ValuesProviderMediator;

public final class ConfigurationProviderToolingAdapter
extends StaticConfigurationProvider
implements MetadataKeyProvider,
ConfigurationParameterValuesProvider {
    private final MuleMetadataService metadataService;
    protected final ConnectionManager connectionManager;
    private final ConfigurationInstance configuration;

    ConfigurationProviderToolingAdapter(String name, ExtensionModel extensionModel, ConfigurationModel configurationModel, ConfigurationInstance configuration, MuleContext muleContext) {
        super(name, extensionModel, configurationModel, configuration, muleContext);
        this.configuration = configuration;
        this.metadataService = (MuleMetadataService)muleContext.getRegistry().get("_muleMetadataService");
        this.connectionManager = (ConnectionManager)muleContext.getRegistry().get("_muleConnectionManager");
    }

    @Override
    public MetadataResult<MetadataKeysContainer> getMetadataKeys() throws MetadataResolvingException {
        MetadataKeysContainerBuilder keysBuilder = MetadataKeysContainerBuilder.getInstance();
        try {
            MetadataContext metadataContext = this.getMetadataContext();
            this.addComponentKeys(this.getConfigurationModel().getOperationModels(), metadataContext, keysBuilder);
            this.addComponentKeys(this.getConfigurationModel().getSourceModels(), metadataContext, keysBuilder);
            metadataContext.dispose();
        }
        catch (Exception e) {
            return MetadataResult.failure(MetadataFailure.Builder.newFailure(e).onKeys());
        }
        return MetadataResult.success(keysBuilder.build());
    }

    private void addComponentKeys(List<? extends ComponentModel> components, MetadataContext metadataContext, MetadataKeysContainerBuilder keysBuilder) throws MetadataResolvingException, ConnectionException {
        for (ComponentModel componentModel : components) {
            TypeKeysResolver keysResolver = MuleExtensionUtils.getMetadataResolverFactory(componentModel).getKeyResolver();
            String categoryName = keysResolver.getCategoryName();
            if ("NullCategory".equals(categoryName) || keysBuilder.containsCategory(categoryName)) continue;
            keysBuilder.add(categoryName, keysResolver.getKeys(metadataContext));
        }
    }

    private MetadataContext getMetadataContext() throws MetadataResolvingException, ConnectionException {
        Event fakeEvent = MuleExtensionUtils.getInitialiserEvent(this.muleContext);
        return new DefaultMetadataContext(Optional.of(this.get(fakeEvent)), this.connectionManager, this.metadataService.getMetadataCache(this.getName()), ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(MuleExtensionUtils.getClassLoader(this.getExtensionModel())));
    }

    @Override
    public Set<Value> getConfigValues(String parameterName) throws ValueResolvingException {
        Reference<Set<Value>> options = new Reference<Set<Value>>();
        ConfigurationModel configurationModel = this.getConfigurationModel();
        ValuesProviderMediator<ConfigurationModel> valuesProviderMediator = new ValuesProviderMediator<ConfigurationModel>(configurationModel, this.muleContext);
        options.set(valuesProviderMediator.getValues(parameterName, this.getParameterValueResolver(this.configuration.getValue(), configurationModel)));
        return (Set)options.get();
    }

    @Override
    public Set<Value> getConnectionValues(String parameterName) throws ValueResolvingException {
        Reference<Set<Value>> options = new Reference<Set<Value>>();
        ConnectionProvider connectionProvider = this.configuration.getConnectionProvider().orElseThrow(() -> new ValueResolvingException("Unable to obtain the Connection Provider Instance", "UNKNOWN"));
        ConnectionProvider unwrap = this.unwrap(connectionProvider);
        ConnectionProviderModel connectionProviderModel = IntrospectionUtils.getConnectionProviderModel(unwrap.getClass(), MuleExtensionUtils.getAllConnectionProviders(this.getExtensionModel(), this.getConfigurationModel())).orElseThrow(() -> new ValueResolvingException("Internal error. Unable to obtain the Connection Provider Model", "UNKNOWN"));
        ValuesProviderMediator<ConnectionProviderModel> valuesProviderMediator = new ValuesProviderMediator<ConnectionProviderModel>(connectionProviderModel, this.muleContext);
        options.set(valuesProviderMediator.getValues(parameterName, this.getParameterValueResolver(unwrap, connectionProviderModel)));
        return (Set)options.get();
    }

    private ParameterValueResolver getParameterValueResolver(Object object, ParameterizedModel configurationModel) {
        return new ObjectBasedParameterValueResolver(object, configurationModel);
    }

    private <C> ConnectionProvider<C> unwrap(ConnectionProvider<C> connectionProvider) {
        return connectionProvider instanceof ConnectionProviderWrapper ? this.unwrap(((ConnectionProviderWrapper)connectionProvider).getDelegate()) : connectionProvider;
    }
}

