/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher.log4j2;

import java.beans.PropertyChangeListener;
import java.net.URI;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.message.MessageFactory;
import org.mule.runtime.core.internal.logging.LogConfigChangeSubject;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.launcher.log4j2.DispatchingLogger;
import org.mule.runtime.module.launcher.log4j2.LoggerContextConfigurer;

class MuleLoggerContext
extends LoggerContext
implements LogConfigChangeSubject {
    private final LoggerContextConfigurer loggerContextConfigurer = new LoggerContextConfigurer();
    private final URI configFile;
    private final boolean standlone;
    private final ContextSelector contextSelector;
    private final boolean artifactClassloader;
    private final boolean applicationClassloader;
    private final String artifactName;
    private final int ownerClassLoaderHash;

    MuleLoggerContext(String name, ContextSelector contextSelector, boolean standalone) {
        this(name, null, null, contextSelector, standalone);
    }

    MuleLoggerContext(String name, URI configLocn, ClassLoader ownerClassLoader, ContextSelector contextSelector, boolean standalone) {
        super(name, null, configLocn);
        int n;
        this.configFile = configLocn;
        this.contextSelector = contextSelector;
        this.standlone = standalone;
        if (ownerClassLoader != null) {
            n = ownerClassLoader.hashCode();
        } else {
            this.getClass().getClassLoader();
            n = this.ownerClassLoaderHash = ClassLoader.getSystemClassLoader().hashCode();
        }
        if (ownerClassLoader instanceof ArtifactClassLoader) {
            this.artifactClassloader = true;
            this.artifactName = this.getArtifactName((ArtifactClassLoader)((Object)ownerClassLoader));
            this.applicationClassloader = ownerClassLoader instanceof RegionClassLoader;
        } else {
            this.artifactClassloader = false;
            this.applicationClassloader = false;
            this.artifactName = null;
        }
    }

    private String getArtifactName(ArtifactClassLoader ownerClassLoader) {
        return ((ArtifactDescriptor)ownerClassLoader.getArtifactDescriptor()).getName();
    }

    public synchronized void reconfigure() {
        this.loggerContextConfigurer.configure(this);
        super.reconfigure();
    }

    public void updateLoggers(Configuration config) {
        this.loggerContextConfigurer.update(this);
        super.updateLoggers(config);
    }

    @Override
    public void registerLogConfigChangeListener(PropertyChangeListener logConfigChangeListener) {
        this.addPropertyChangeListener(logConfigChangeListener);
    }

    @Override
    public void unregisterLogConfigChangeListener(PropertyChangeListener logConfigChangeListener) {
        this.removePropertyChangeListener(logConfigChangeListener);
    }

    protected Logger newInstance(LoggerContext ctx, String name, MessageFactory messageFactory) {
        return new DispatchingLogger(super.newInstance(ctx, name, messageFactory), this.ownerClassLoaderHash, this, this.contextSelector, messageFactory){

            public String getName() {
                return this.name;
            }
        };
    }

    protected URI getConfigFile() {
        return this.configFile;
    }

    protected boolean isStandlone() {
        return this.standlone;
    }

    protected boolean isArtifactClassloader() {
        return this.artifactClassloader;
    }

    protected boolean isApplicationClassloader() {
        return this.applicationClassloader;
    }

    protected String getArtifactName() {
        return this.artifactName;
    }
}

