/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.reader;

import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import org.mule.weave.v2.module.reader.CharsetHelper$;
import org.mule.weave.v2.module.reader.SeekableStream;
import org.mule.weave.v2.module.reader.SourceReader;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001B\u0001\u0003\u0001=\u0011a#\u0016+GqM#(/Z1n'>,(oY3SK\u0006$WM\u001d\u0006\u0003\u0007\u0011\taA]3bI\u0016\u0014(BA\u0003\u0007\u0003\u0019iw\u000eZ;mK*\u0011q\u0001C\u0001\u0003mJR!!\u0003\u0006\u0002\u000b],\u0017M^3\u000b\u0005-a\u0011\u0001B7vY\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0004\u0001AA\u0002CA\t\u0017\u001b\u0005\u0011\"BA\n\u0015\u0003\u0011a\u0017M\\4\u000b\u0003U\tAA[1wC&\u0011qC\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005eQR\"\u0001\u0002\n\u0005m\u0011!\u0001D*pkJ\u001cWMU3bI\u0016\u0014\b\u0002C\u000f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002\u001dM,Wm[1cY\u0016\u001cFO]3b[B\u0011\u0011dH\u0005\u0003A\t\u0011abU3fW\u0006\u0014G.Z*ue\u0016\fW\u000e\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003$\u0003\u001d\u0019\u0007.\u0019:tKR\u0004\"\u0001\n\u0015\u000e\u0003\u0015R!A\t\u0014\u000b\u0005\u001d\"\u0012a\u00018j_&\u0011\u0011&\n\u0002\b\u0007\"\f'o]3u\u0011\u0015Y\u0003\u0001\"\u0001-\u0003\u0019a\u0014N\\5u}Q\u0019QFL\u0018\u0011\u0005e\u0001\u0001\"B\u000f+\u0001\u0004q\u0002\"\u0002\u0012+\u0001\u0004\u0019\u0003\u0002C\u0019\u0001\u0011\u000b\u0007I\u0011\u0001\u001a\u0002\u000f\u0011,7m\u001c3feV\t1\u0007\u0005\u0002%i%\u0011Q'\n\u0002\u000f\u0007\"\f'o]3u\t\u0016\u001cw\u000eZ3s\u0011\u001d9\u0004A1A\u0005\na\n!b\u00195be\n+hMZ3s+\u0005I\u0004C\u0001\u001e<\u001b\u00051\u0013B\u0001\u001f'\u0005)\u0019\u0005.\u0019:Ck\u001a4WM\u001d\u0005\u0007}\u0001\u0001\u000b\u0011B\u001d\u0002\u0017\rD\u0017M\u001d\"vM\u001a,'\u000f\t\u0005\b\u0001\u0002\u0001\r\u0011\"\u00039\u00035\u0011\u0017nZ\"iCJ\u0014UO\u001a4fe\"9!\t\u0001a\u0001\n\u0013\u0019\u0015!\u00052jO\u000eC\u0017M\u001d\"vM\u001a,'o\u0018\u0013fcR\u0011AI\u0013\t\u0003\u000b\"k\u0011A\u0012\u0006\u0002\u000f\u0006)1oY1mC&\u0011\u0011J\u0012\u0002\u0005+:LG\u000fC\u0004L\u0003\u0006\u0005\t\u0019A\u001d\u0002\u0007a$\u0013\u0007\u0003\u0004N\u0001\u0001\u0006K!O\u0001\u000fE&<7\t[1s\u0005V4g-\u001a:!\u0011\u001dy\u0005\u00011A\u0005\u0002A\u000b!b\u0018:fC\u0012\u0014\u0015\u0010^3t+\u0005\t\u0006CA#S\u0013\t\u0019fIA\u0002J]RDq!\u0016\u0001A\u0002\u0013\u0005a+\u0001\b`e\u0016\fGMQ=uKN|F%Z9\u0015\u0005\u0011;\u0006bB&U\u0003\u0003\u0005\r!\u0015\u0005\u00073\u0002\u0001\u000b\u0015B)\u0002\u0017}\u0013X-\u00193CsR,7\u000f\t\u0005\u00067\u0002!\t\u0005X\u0001\ne\u0016\fG-Q:dS&$\u0012!\u0018\t\u0003\u000bzK!a\u0018$\u0003\t\rC\u0017M\u001d\u0005\u0006C\u0002!\tAY\u0001\nQ\u0006tG\r\\3C\u001f6#\u0012\u0001\u0012\u0005\u0006I\u0002!\t%Z\u0001\ta>\u001c\u0018\u000e^5p]R\ta\r\u0005\u0002FO&\u0011\u0001N\u0012\u0002\u0005\u0019>tw\rC\u0003k\u0001\u0011\u0005S-\u0001\tqe\u00164\u0018n\\;t!>\u001c\u0018\u000e^5p]\")A\u000e\u0001C!9\u0006qAn\\8l\u0003\",\u0017\rZ!tG&L\u0007\"\u00028\u0001\t\u0003z\u0017\u0001B:fK.$\"\u0001\u00129\t\u000b\u0011l\u0007\u0019\u00014\t\u000bI\u0004A\u0011I:\u0002\u001d%tW*Z7pef\u0014V-\u00193feR\tA\u000f\u0005\u0002Fk&\u0011aO\u0012\u0002\b\u0005>|G.Z1o\u0011\u0015A\b\u0001\"\u0011]\u0003\u0011\u0011X-\u00193\t\u000bi\u0004A\u0011A>\u0002#I,\u0017\rZ#oG>$W\rZ*ue&tw\rF\u0003}\u0003\u001f\t\u0019\u0002E\u0002~\u0003\u0013q1A`A\u0003!\tyh)\u0004\u0002\u0002\u0002)\u0019\u00111\u0001\b\u0002\rq\u0012xn\u001c;?\u0013\r\t9AR\u0001\u0007!J,G-\u001a4\n\t\u0005-\u0011Q\u0002\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u001da\t\u0003\u0004\u0002\u0012e\u0004\rAZ\u0001\u0005MJ|W\u000e\u0003\u0004\u0002\u0016e\u0004\rAZ\u0001\u0007Y\u0016tw\r\u001e5\t\u000f\u0005e\u0001\u0001\"\u0011\u0002\u001c\u0005y!/Z1e\u0003N\u001c\u0017.[*ue&tw\rF\u0003}\u0003;\ty\u0002C\u0004\u0002\u0012\u0005]\u0001\u0019\u00014\t\u000f\u0005U\u0011q\u0003a\u0001M\"1\u00111\u0005\u0001\u0005B\t\fQa\u00197pg\u0016\u0004")
public class UTF8StreamSourceReader
implements SourceReader {
    private CharsetDecoder decoder;
    private final SeekableStream seekableStream;
    private final Charset charset;
    private final CharBuffer charBuffer;
    private CharBuffer bigCharBuffer;
    private int _readBytes;
    private volatile boolean bitmap$0;

    private CharsetDecoder decoder$lzycompute() {
        UTF8StreamSourceReader uTF8StreamSourceReader = this;
        synchronized (uTF8StreamSourceReader) {
            if (!this.bitmap$0) {
                this.decoder = this.charset.newDecoder();
                this.bitmap$0 = true;
            }
        }
        return this.decoder;
    }

    public CharsetDecoder decoder() {
        return !this.bitmap$0 ? this.decoder$lzycompute() : this.decoder;
    }

    private CharBuffer charBuffer() {
        return this.charBuffer;
    }

    private CharBuffer bigCharBuffer() {
        return this.bigCharBuffer;
    }

    private void bigCharBuffer_$eq(CharBuffer x$1) {
        this.bigCharBuffer = x$1;
    }

    public int _readBytes() {
        return this._readBytes;
    }

    public void _readBytes_$eq(int x$1) {
        this._readBytes = x$1;
    }

    @Override
    public char readAscii() {
        char c;
        int read;
        if (this.seekableStream.position() == 0L) {
            this.handleBOM();
        }
        if ((read = ((InputStream)((Object)this.seekableStream)).read()) != -1) {
            this._readBytes_$eq(1);
            c = (char)(read & 0xFF);
        } else {
            this._readBytes_$eq(0);
            c = '\uffff';
        }
        return c;
    }

    public void handleBOM() {
        block0: {
            Option<byte[]> mayBeBom = CharsetHelper$.MODULE$.getBom(this.charset);
            byte[] bom = (byte[])mayBeBom.get();
            byte[] inputBom = new byte[bom.length];
            ((InputStream)((Object)this.seekableStream)).read(inputBom);
            if (inputBom[0] == bom[0] && inputBom[1] == bom[1] && inputBom[2] == bom[2]) break block0;
            this.seekableStream.seek(0L);
        }
    }

    @Override
    public long position() {
        return this.seekableStream.position();
    }

    @Override
    public long previousPosition() {
        return this.position() - (long)this._readBytes();
    }

    @Override
    public char lookAheadAscii() {
        char c;
        long startPosition = this.position();
        try {
            c = this.readAscii();
        }
        finally {
            this.seek(startPosition);
        }
        return c;
    }

    @Override
    public void seek(long position) {
        this.seekableStream.seek(position);
    }

    @Override
    public boolean inMemoryReader() {
        return this.seekableStream.inMemoryStream();
    }

    @Override
    public char read() {
        char c;
        byte _read = (byte)((InputStream)((Object)this.seekableStream)).read();
        if (_read == -1) {
            this._readBytes_$eq(0);
            c = '\uffff';
        } else if (_read >= 0) {
            this._readBytes_$eq(1);
            c = (char)_read;
        } else if ((_read & 0xE0) == 192) {
            this._readBytes_$eq(2);
            c = this.decode$1(_read, 1);
        } else if ((_read & 0xF0) == 224) {
            this._readBytes_$eq(3);
            c = this.decode$1(_read, 2);
        } else if ((_read & 0xF8) == 240) {
            this._readBytes_$eq(4);
            c = this.decode$1(_read, 3);
        } else {
            c = (char)65533;
        }
        return c;
    }

    @Override
    public String readEncodedString(long from, long length) {
        byte[] bytes = new byte[(int)length];
        this.seek(from);
        ((InputStream)((Object)this.seekableStream)).read(bytes, 0, (int)length);
        if ((long)this.bigCharBuffer().capacity() < length) {
            this.bigCharBuffer_$eq(CharBuffer.allocate((int)length));
        }
        this.bigCharBuffer().clear();
        CoderResult cr = this.decoder().decode(ByteBuffer.wrap(bytes), this.bigCharBuffer(), false);
        int decodedLength = this.bigCharBuffer().position();
        return new String(this.bigCharBuffer().array(), 0, decodedLength);
    }

    @Override
    public String readAsciiString(long from, long length) {
        byte[] bytes = new byte[(int)length];
        this.seek(from);
        ((InputStream)((Object)this.seekableStream)).read(bytes, 0, (int)length);
        return new String(bytes, StandardCharsets.US_ASCII);
    }

    @Override
    public void close() {
        ((InputStream)((Object)this.seekableStream)).close();
    }

    private final char decode$1(byte by, int remainingBytes) {
        char c;
        this.charBuffer().clear();
        byte[] bytes = new byte[remainingBytes + 1];
        bytes[0] = by;
        int readAmount = ((InputStream)((Object)this.seekableStream)).read(bytes, 1, remainingBytes);
        this.decoder().decode(ByteBuffer.wrap(bytes), this.charBuffer(), false);
        this.charBuffer().flip();
        try {
            c = this.charBuffer().get();
        }
        catch (BufferUnderflowException e) {
            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to decode character at position in bytes ", ". Amount of bytes read ", " expected ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.previousPosition()), BoxesRunTime.boxToInteger((int)readAmount), BoxesRunTime.boxToInteger((int)remainingBytes)})), e);
        }
        return c;
    }

    public UTF8StreamSourceReader(SeekableStream seekableStream, Charset charset) {
        this.seekableStream = seekableStream;
        this.charset = charset;
        SourceReader.$init$(this);
        this.charBuffer = CharBuffer.allocate(1);
        this.bigCharBuffer = CharBuffer.allocate(8192);
        this._readBytes = 0;
    }
}

