/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.util;

import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class StringValueUtils$ {
    public static StringValueUtils$ MODULE$;

    static {
        new StringValueUtils$();
    }

    public String handleEscapeChars(String str, char quotedBy) {
        Iterator charIterator = new StringOps(Predef$.MODULE$.augmentString(str)).iterator();
        StringBuilder result = new StringBuilder();
        while (charIterator.hasNext()) {
            StringBuilder stringBuilder;
            char next = BoxesRunTime.unboxToChar((Object)charIterator.next());
            if (next == '\\' && charIterator.hasNext()) {
                char controlChar = BoxesRunTime.unboxToChar((Object)charIterator.next());
                if (controlChar == quotedBy) {
                    stringBuilder = result.append(controlChar);
                    continue;
                }
                char c = controlChar;
                switch (c) {
                    case '/': 
                    case '\\': {
                        stringBuilder = result.append(controlChar);
                        break;
                    }
                    case 'n': {
                        stringBuilder = result.append('\n');
                        break;
                    }
                    case 'b': {
                        stringBuilder = result.append('\b');
                        break;
                    }
                    case 'f': {
                        stringBuilder = result.append('\f');
                        break;
                    }
                    case 'r': {
                        stringBuilder = result.append('\r');
                        break;
                    }
                    case 't': {
                        stringBuilder = result.append('\t');
                        break;
                    }
                    case '$': {
                        stringBuilder = result.append('$');
                        break;
                    }
                    default: {
                        stringBuilder = result.append(next).append(controlChar);
                        break;
                    }
                }
                continue;
            }
            stringBuilder = result.append(next);
        }
        return result.toString();
    }

    public String abbreviate(String str, int maxWidth) {
        int offset = 0;
        if (str == null) {
            return null;
        }
        if (maxWidth < 4) {
            throw new IllegalArgumentException("Minimum abbreviation width is 4");
        }
        if (str.length() <= maxWidth) {
            return str;
        }
        if (str.length() < maxWidth - 3) {
            offset = str.length() - (maxWidth - 3);
        }
        String abrevMarker = "...";
        if (offset <= 4) {
            return str.substring(0, maxWidth - 3) + abrevMarker;
        }
        if (maxWidth < 7) {
            throw new IllegalArgumentException("Minimum abbreviation width with offset is 7");
        }
        if (offset + maxWidth - 3 < str.length()) {
            return abrevMarker + this.abbreviate(str.substring(offset), maxWidth - 3);
        }
        return abrevMarker + str.substring(str.length() - (maxWidth - 3));
    }

    public String rightPad(String str, int len) {
        return ((TraversableOnce)new StringOps(Predef$.MODULE$.augmentString(str)).padTo(len, (Object)" ", Predef$.MODULE$.fallbackStringCanBuildFrom())).mkString();
    }

    public String leftPad(String str, int len) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"%", "s"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)len)})))).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str}));
    }

    private StringValueUtils$() {
        MODULE$ = this;
    }
}

