/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.utils;

import java.io.Serializable;
import org.mule.weave.v2.codegen.CodeWriter;
import org.mule.weave.v2.codegen.StringCodeWriter;
import org.mule.weave.v2.parser.ast.QName;
import org.mule.weave.v2.ts.AnyType;
import org.mule.weave.v2.ts.ArrayType;
import org.mule.weave.v2.ts.BinaryType;
import org.mule.weave.v2.ts.BooleanType;
import org.mule.weave.v2.ts.DateTimeType;
import org.mule.weave.v2.ts.DynamicReturnType;
import org.mule.weave.v2.ts.FunctionType;
import org.mule.weave.v2.ts.FunctionTypeParameter;
import org.mule.weave.v2.ts.IntersectionType;
import org.mule.weave.v2.ts.KeyType;
import org.mule.weave.v2.ts.KeyValuePairType;
import org.mule.weave.v2.ts.LocalDateTimeType;
import org.mule.weave.v2.ts.LocalDateType;
import org.mule.weave.v2.ts.LocalTimeType;
import org.mule.weave.v2.ts.NameType;
import org.mule.weave.v2.ts.NameValuePairType;
import org.mule.weave.v2.ts.NamespaceType;
import org.mule.weave.v2.ts.NothingType;
import org.mule.weave.v2.ts.NullType;
import org.mule.weave.v2.ts.NumberType;
import org.mule.weave.v2.ts.ObjectType;
import org.mule.weave.v2.ts.PeriodType;
import org.mule.weave.v2.ts.RangeType;
import org.mule.weave.v2.ts.ReferenceType;
import org.mule.weave.v2.ts.RegexType;
import org.mule.weave.v2.ts.StringType;
import org.mule.weave.v2.ts.TimeType;
import org.mule.weave.v2.ts.TimeZoneType;
import org.mule.weave.v2.ts.TypeParameter;
import org.mule.weave.v2.ts.TypeType;
import org.mule.weave.v2.ts.UnionType;
import org.mule.weave.v2.ts.WeaveType;
import org.mule.weave.v2.ts.WeaveTypeAnnotation;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;

public final class WeaveTypeEmitter$ {
    public static WeaveTypeEmitter$ MODULE$;

    static {
        new WeaveTypeEmitter$();
    }

    public String toString(WeaveType wtype) {
        StringCodeWriter builder = new StringCodeWriter();
        this.generate(wtype, builder);
        return builder.codeContent();
    }

    private void generate(WeaveType wtype, StringCodeWriter builder) {
        block72: {
            CodeWriter codeWriter;
            WeaveType weaveType = wtype;
            if (weaveType instanceof ObjectType) {
                CodeWriter codeWriter2;
                ObjectType objectType = (ObjectType)weaveType;
                Seq<KeyValuePairType> properties = objectType.properties();
                if (properties.isEmpty()) {
                    codeWriter2 = builder.print("Object");
                } else {
                    builder.print("{");
                    builder.indent();
                    ((IterableLike)properties.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)indexProp -> {
                        WeaveTypeEmitter$.$anonfun$generate$1(this, builder, indexProp);
                        return BoxedUnit.UNIT;
                    });
                    builder.dedent();
                    codeWriter2 = builder.print("}");
                }
                codeWriter = codeWriter2;
            } else if (weaveType instanceof KeyValuePairType) {
                KeyValuePairType keyValuePairType = (KeyValuePairType)weaveType;
                WeaveType key = keyValuePairType.key();
                WeaveType value = keyValuePairType.value();
                boolean optional = keyValuePairType.optional();
                this.generate(key, builder);
                Object object = optional ? builder.print("?") : BoxedUnit.UNIT;
                builder.printSpace(":");
                this.generate(value, builder);
                codeWriter = BoxedUnit.UNIT;
            } else if (weaveType instanceof KeyType) {
                Object object;
                KeyType keyType = (KeyType)weaveType;
                WeaveType name = keyType.name();
                Seq<NameValuePairType> attrs = keyType.attrs();
                this.generate(name, builder);
                if (attrs.nonEmpty()) {
                    builder.print(" @(");
                    ((IterableLike)attrs.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)attr -> {
                        WeaveTypeEmitter$.$anonfun$generate$2(this, builder, attr);
                        return BoxedUnit.UNIT;
                    });
                    object = builder.print(")");
                } else {
                    object = BoxedUnit.UNIT;
                }
                codeWriter = object;
            } else if (weaveType instanceof NameValuePairType) {
                NameValuePairType nameValuePairType = (NameValuePairType)weaveType;
                WeaveType name = nameValuePairType.name();
                WeaveType value = nameValuePairType.value();
                this.generate(name, builder);
                builder.print(": ");
                this.generate(value, builder);
                codeWriter = BoxedUnit.UNIT;
            } else if (weaveType instanceof NameType) {
                CodeWriter codeWriter3;
                NameType nameType = (NameType)weaveType;
                Option<QName> name = nameType.value();
                Option<QName> option = name;
                if (option instanceof Some) {
                    Object object;
                    Some some = (Some)option;
                    QName qName = (QName)some.value();
                    if (qName.ns().isDefined()) {
                        builder.print((String)qName.ns().get());
                        object = builder.print("#");
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    codeWriter3 = builder.print(qName.name());
                } else if (None$.MODULE$.equals(option)) {
                    codeWriter3 = builder.print("Name");
                } else {
                    throw new MatchError(option);
                }
                codeWriter = codeWriter3;
            } else if (weaveType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)weaveType;
                WeaveType of = arrayType.of();
                builder.print("Array<");
                this.generate(of, builder);
                codeWriter = builder.print(">");
            } else if (weaveType instanceof UnionType) {
                UnionType unionType = (UnionType)weaveType;
                Seq<WeaveType> of = unionType.of();
                ((IterableLike)of.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)item -> {
                    WeaveTypeEmitter$.$anonfun$generate$3(this, builder, item);
                    return BoxedUnit.UNIT;
                });
                codeWriter = BoxedUnit.UNIT;
            } else if (weaveType instanceof IntersectionType) {
                IntersectionType intersectionType = (IntersectionType)weaveType;
                Seq<WeaveType> of = intersectionType.of();
                ((IterableLike)of.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)item -> {
                    WeaveTypeEmitter$.$anonfun$generate$4(this, builder, item);
                    return BoxedUnit.UNIT;
                });
                codeWriter = BoxedUnit.UNIT;
            } else if (weaveType instanceof StringType) {
                codeWriter = builder.print("String");
            } else if (weaveType instanceof AnyType) {
                codeWriter = builder.print("Any");
            } else if (weaveType instanceof BooleanType) {
                codeWriter = builder.print("Boolean");
            } else if (weaveType instanceof NumberType) {
                codeWriter = builder.print("Number");
            } else if (weaveType instanceof RangeType) {
                codeWriter = builder.print("Range");
            } else if (weaveType instanceof RegexType) {
                codeWriter = builder.print("Regex");
            } else if (weaveType instanceof NullType) {
                codeWriter = builder.print("Null");
            } else if (weaveType instanceof DateTimeType) {
                codeWriter = builder.print("DateTime");
            } else if (weaveType instanceof LocalDateTimeType) {
                codeWriter = builder.print("LocalDateTime");
            } else if (weaveType instanceof LocalDateType) {
                codeWriter = builder.print("LocalDate");
            } else if (weaveType instanceof LocalTimeType) {
                codeWriter = builder.print("LocalTime");
            } else if (weaveType instanceof TimeType) {
                codeWriter = builder.print("Time");
            } else if (weaveType instanceof TimeZoneType) {
                codeWriter = builder.print("TimeZone");
            } else if (weaveType instanceof PeriodType) {
                codeWriter = builder.print("Period");
            } else if (weaveType instanceof BinaryType) {
                codeWriter = builder.print("Binary");
            } else if (weaveType instanceof TypeParameter) {
                BoxedUnit boxedUnit;
                TypeParameter typeParameter = (TypeParameter)weaveType;
                String name = typeParameter.name();
                Option<WeaveType> bt = typeParameter.baseType();
                builder.print(name);
                if (bt.isDefined()) {
                    builder.print(" is ");
                    this.generate((WeaveType)bt.get(), builder);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                codeWriter = boxedUnit;
            } else if (weaveType instanceof FunctionType) {
                FunctionType functionType = (FunctionType)weaveType;
                Seq<FunctionTypeParameter> args = functionType.params();
                WeaveType returnType = functionType.returnType();
                builder.print("(");
                ((IterableLike)args.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)item -> {
                    WeaveTypeEmitter$.$anonfun$generate$5(this, builder, item);
                    return BoxedUnit.UNIT;
                });
                builder.printSpace(")");
                builder.printSpace("=>");
                this.generate(returnType, builder);
                codeWriter = BoxedUnit.UNIT;
            } else if (weaveType instanceof TypeType) {
                TypeType typeType = (TypeType)weaveType;
                WeaveType t = typeType.t();
                builder.print("Type<");
                this.generate(t, builder);
                codeWriter = builder.print(">");
            } else if (weaveType instanceof NothingType) {
                codeWriter = builder.print("Nothing");
            } else if (weaveType instanceof NamespaceType) {
                codeWriter = builder.print("Namespace");
            } else if (weaveType instanceof DynamicReturnType) {
                codeWriter = builder.print(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UndefinedReturn"})).s((Seq)Nil$.MODULE$));
            } else if (weaveType instanceof ReferenceType) {
                ReferenceType referenceType = (ReferenceType)weaveType;
                this.generate(referenceType.resolveType(), builder);
                codeWriter = BoxedUnit.UNIT;
            } else {
                codeWriter = builder.print(wtype.getClass().getSimpleName());
            }
            if (!wtype.annotations().nonEmpty()) break block72;
            builder.printSpace();
            builder.print("{");
            builder.printForeachWithSeparator(",\n", wtype.annotations(), (Function1 & Serializable & scala.Serializable)annotation -> {
                WeaveTypeEmitter$.$anonfun$generate$6(builder, annotation);
                return BoxedUnit.UNIT;
            });
            builder.print("}");
        }
    }

    public CodeWriter printQName(StringCodeWriter builder, QName name) {
        return builder.print(name.name());
    }

    public static final /* synthetic */ void $anonfun$generate$1(WeaveTypeEmitter$ $this, StringCodeWriter builder$1, Tuple2 indexProp) {
        Object object = indexProp._2$mcI$sp() > 0 ? builder$1.printSpace(",") : BoxedUnit.UNIT;
        $this.generate((WeaveType)indexProp._1(), builder$1);
    }

    public static final /* synthetic */ void $anonfun$generate$2(WeaveTypeEmitter$ $this, StringCodeWriter builder$1, Tuple2 attr) {
        Object object = attr._2$mcI$sp() > 0 ? builder$1.printSpace(",") : BoxedUnit.UNIT;
        $this.generate((WeaveType)attr._1(), builder$1);
    }

    public static final /* synthetic */ void $anonfun$generate$3(WeaveTypeEmitter$ $this, StringCodeWriter builder$1, Tuple2 item) {
        Object object = item._2$mcI$sp() > 0 ? builder$1.print(" | ") : BoxedUnit.UNIT;
        $this.generate((WeaveType)item._1(), builder$1);
    }

    public static final /* synthetic */ void $anonfun$generate$4(WeaveTypeEmitter$ $this, StringCodeWriter builder$1, Tuple2 item) {
        Object object = item._2$mcI$sp() > 0 ? builder$1.print(" & ") : BoxedUnit.UNIT;
        $this.generate((WeaveType)item._1(), builder$1);
    }

    public static final /* synthetic */ void $anonfun$generate$5(WeaveTypeEmitter$ $this, StringCodeWriter builder$1, Tuple2 item) {
        Object object = item._2$mcI$sp() > 0 ? builder$1.print(", ") : BoxedUnit.UNIT;
        builder$1.print(((FunctionTypeParameter)item._1()).name()).printSpace(":");
        $this.generate(((FunctionTypeParameter)item._1()).wtype(), builder$1);
    }

    public static final /* synthetic */ void $anonfun$generate$6(StringCodeWriter builder$1, WeaveTypeAnnotation annotation) {
        builder$1.printQuoted(annotation.name()).printSpace(":").printQuoted(annotation.value().toString());
    }

    private WeaveTypeEmitter$() {
        MODULE$ = this;
    }
}

