/**
 * Returns a list of entries describing the object.
 */
fun entrySet<T <: Object>(obj: T) =
  obj pluck (value, key) -> {
    key: key,
    name: key as String,
    namespace: key.#,
    attributes: key.@,
    value: value
  }

/**
 * The merge function is used to copy the values of all properties the source object to a target object.
 * Properties in the target object will be overwritten by properties in the sources if they have the same key.
 */
fun merge<T <: Object,V <: Object>(a: T, b: V) =
  (a removeKeys (entrySet(b) map $.name)) ++ b

fun merge<T>(a: Null, b: T): T = b

fun merge<T>(a: T, b: Null): T = a

/**
 * Removes the properties from an object that matches the given list of keys
 */
fun removeKeys(a: Object, keys: Array<String>) =
  keys reduce (key, obj = a) -> (obj - key)