/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.app.declaration.ArtifactDeclaration;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.value.ValueProviderService;
import org.mule.runtime.config.spring.LazyComponentInitializer;
import org.mule.runtime.config.spring.LazyConnectivityTestingService;
import org.mule.runtime.config.spring.LazyMetadataService;
import org.mule.runtime.config.spring.LazyValueProviderService;
import org.mule.runtime.config.spring.MuleArtifactContext;
import org.mule.runtime.config.spring.OptionalObjectsController;
import org.mule.runtime.config.spring.XmlConfigurationDocumentLoader;
import org.mule.runtime.config.spring.dsl.model.ApplicationModel;
import org.mule.runtime.config.spring.dsl.model.ComponentModel;
import org.mule.runtime.config.spring.dsl.model.MinimalApplicationModelGenerator;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigResource;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.connectivity.ConnectivityTestingService;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.value.MuleValueProviderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class LazyMuleArtifactContext
extends MuleArtifactContext
implements LazyComponentInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(LazyMuleArtifactContext.class);
    private ConnectivityTestingService lazyConnectivityTestingService;
    private ValueProviderService valueProviderService;
    private MetadataService metadataService;

    public LazyMuleArtifactContext(MuleContext muleContext, ConfigResource[] artifactConfigResources, ArtifactDeclaration artifactDeclaration, OptionalObjectsController optionalObjectsController, Map<String, String> artifactProperties, ArtifactType artifactType, List<ClassLoader> pluginsClassLoaders, Optional<ConfigurationProperties> parentConfigurationProperties) throws BeansException {
        super(muleContext, artifactConfigResources, artifactDeclaration, optionalObjectsController, artifactProperties, artifactType, pluginsClassLoaders, parentConfigurationProperties);
        this.applicationModel.executeOnEveryMuleComponentTree(componentModel -> componentModel.setEnabled(false));
    }

    @Override
    protected XmlConfigurationDocumentLoader newXmlConfigurationDocumentLoader() {
        return XmlConfigurationDocumentLoader.noValidationDocumentLoader();
    }

    private void createComponents(DefaultListableBeanFactory beanFactory, ApplicationModel applicationModel, boolean mustBeRoot) {
        this.applyLifecycle(super.createApplicationComponents(beanFactory, applicationModel, mustBeRoot));
    }

    private void applyLifecycle(List<String> createdComponentModels) {
        Object object;
        if (this.muleContext.isInitialised()) {
            for (String createdComponentModelName : createdComponentModels) {
                object = this.muleContext.getRegistry().get(createdComponentModelName);
                try {
                    LifecycleUtils.initialiseIfNeeded(object, true, this.muleContext);
                }
                catch (InitialisationException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.muleContext.isStarted()) {
            for (String createdComponentModelName : createdComponentModels) {
                object = this.muleContext.getRegistry().get(createdComponentModelName);
                try {
                    LifecycleUtils.startIfNeeded(object);
                }
                catch (MuleException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public void initializeComponent(Location location) {
        ClassUtils.withContextClassLoader(this.muleContext.getExecutionClassLoader(), () -> {
            MinimalApplicationModelGenerator minimalApplicationModelGenerator = new MinimalApplicationModelGenerator(this.applicationModel, this.componentBuildingDefinitionRegistry);
            this.unregisterComponents(minimalApplicationModelGenerator.resolveComponentModelDependencies());
            ApplicationModel minimalApplicationModel = minimalApplicationModelGenerator.getMinimalModel(location);
            this.createComponents((DefaultListableBeanFactory)this.getBeanFactory(), minimalApplicationModel, false);
        });
    }

    private void unregisterComponents(List<ComponentModel> componentModels) {
        if (this.muleContext.isStarted()) {
            componentModels.stream().forEach(componentModel -> {
                block3: {
                    String nameAttribute = componentModel.getNameAttribute();
                    if (nameAttribute != null) {
                        try {
                            this.muleContext.getRegistry().unregisterObject(nameAttribute);
                        }
                        catch (Exception e) {
                            this.logger.warn((Object)String.format("Exception unregistering an object during lazy initialization of component %s, exception message is %s", nameAttribute, e.getMessage()));
                            if (!this.logger.isDebugEnabled()) break block3;
                            this.logger.debug((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
            });
        }
        this.applicationModel.executeOnEveryMuleComponentTree(componentModel -> componentModel.setEnabled(false));
    }

    @Override
    public ConnectivityTestingService getConnectivityTestingService() {
        if (this.lazyConnectivityTestingService == null) {
            this.lazyConnectivityTestingService = new LazyConnectivityTestingService(this, (ConnectivityTestingService)this.muleContext.getRegistry().get("_muleConnectivityTestingService"));
        }
        return this.lazyConnectivityTestingService;
    }

    @Override
    public MetadataService getMetadataService() {
        if (this.metadataService == null) {
            this.metadataService = new LazyMetadataService(this, (MetadataService)this.muleContext.getRegistry().get("_muleMetadataService"));
        }
        return this.metadataService;
    }

    @Override
    public ValueProviderService getValueProviderService() {
        if (this.valueProviderService == null) {
            this.valueProviderService = new LazyValueProviderService(this, (MuleValueProviderService)this.muleContext.getRegistry().get("_muleValueProviderService"));
        }
        return this.valueProviderService;
    }
}

