/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring;

import java.util.Optional;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.value.ResolvingFailure;
import org.mule.runtime.api.value.ValueProviderService;
import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.config.spring.LazyMuleArtifactContext;
import org.mule.runtime.core.internal.value.MuleValueProviderService;
import org.mule.runtime.core.internal.value.MuleValueProviderServiceUtility;

public class LazyValueProviderService
implements ValueProviderService {
    private LazyMuleArtifactContext lazyMuleArtifactContext;
    private ValueProviderService providerService;

    LazyValueProviderService(LazyMuleArtifactContext artifactContext, MuleValueProviderService providerServiceDelegate) {
        this.lazyMuleArtifactContext = artifactContext;
        this.providerService = providerServiceDelegate;
    }

    @Override
    public ValueResult getValues(Location location, String providerName) {
        return this.initializeComponent(this.locationWithOutConnection(location)).orElseGet(() -> this.providerService.getValues(location, providerName));
    }

    private Optional<ValueResult> initializeComponent(Location location) {
        try {
            this.lazyMuleArtifactContext.initializeComponent(location);
        }
        catch (Exception e) {
            return Optional.of(ValueResult.resultFrom(ResolvingFailure.Builder.newFailure(e).build()));
        }
        return Optional.empty();
    }

    private Location locationWithOutConnection(Location location) {
        return MuleValueProviderServiceUtility.isConnection(location) ? MuleValueProviderServiceUtility.deleteLastPartFromLocation(location) : location;
    }
}

