/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.dsl.model;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.app.declaration.ArtifactDeclaration;
import org.mule.runtime.api.app.declaration.ElementDeclaration;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.config.spring.dsl.model.ComponentBuildingDefinitionRegistry;
import org.mule.runtime.config.spring.dsl.model.ComponentLocationVisitor;
import org.mule.runtime.config.spring.dsl.model.ComponentModel;
import org.mule.runtime.config.spring.dsl.model.ComponentModelReader;
import org.mule.runtime.config.spring.dsl.model.DslElementModel;
import org.mule.runtime.config.spring.dsl.model.DslElementModelFactory;
import org.mule.runtime.config.spring.dsl.model.extension.xml.MacroExpansionModuleModel;
import org.mule.runtime.config.spring.dsl.processor.ArtifactConfig;
import org.mule.runtime.config.spring.dsl.processor.ConfigFile;
import org.mule.runtime.config.spring.dsl.processor.ConfigLine;
import org.mule.runtime.config.spring.dsl.processor.ObjectTypeVisitor;
import org.mule.runtime.config.spring.dsl.processor.xml.XmlCustomAttributeHandler;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.RuntimeConfigurationException;
import org.mule.runtime.core.component.config.CompositeConfigurationPropertiesProvider;
import org.mule.runtime.core.component.config.ConfigurationPropertiesComponent;
import org.mule.runtime.core.component.config.ConfigurationPropertiesProvider;
import org.mule.runtime.core.component.config.ConfigurationPropertiesResolver;
import org.mule.runtime.core.component.config.ConfigurationProperty;
import org.mule.runtime.core.component.config.DefaultConfigurationPropertiesResolver;
import org.mule.runtime.core.component.config.FileConfigurationPropertiesProvider;
import org.mule.runtime.core.component.config.GlobalPropertyConfigurationPropertiesProvider;
import org.mule.runtime.core.component.config.MapConfigurationPropertiesProvider;
import org.mule.runtime.core.component.config.PropertiesResolverConfigurationProperties;
import org.mule.runtime.core.component.config.ResourceProvider;
import org.mule.runtime.core.component.config.SystemPropertiesConfigurationProvider;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinitionProvider;
import org.mule.runtime.dsl.api.component.config.ComponentConfiguration;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.extension.api.util.NameUtils;
import org.w3c.dom.Node;

public class ApplicationModel {
    public static final String MULE_ROOT_ELEMENT = "mule";
    public static final String MULE_DOMAIN_ROOT_ELEMENT = "mule-domain";
    public static final String IMPORT_ELEMENT = "import";
    public static final String POLICY_ROOT_ELEMENT = "policy";
    public static final String ANNOTATIONS = "annotations";
    public static final String ERROR_HANDLER = "error-handler";
    public static final String ERROR_MAPPING = "error-mapping";
    public static final String MAX_REDELIVERY_ATTEMPTS_ROLLBACK_ES_ATTRIBUTE = "maxRedeliveryAttempts";
    public static final String WHEN_CHOICE_ES_ATTRIBUTE = "when";
    public static final String TYPE_ES_ATTRIBUTE = "type";
    public static final String EXCEPTION_STRATEGY_REFERENCE_ELEMENT = "exception-strategy";
    public static final String PROPERTY_ELEMENT = "property";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String REFERENCE_ATTRIBUTE = "ref";
    public static final String VALUE_ATTRIBUTE = "value";
    public static final String PROCESSOR_REFERENCE_ELEMENT = "processor";
    public static final String TRANSFORMER_REFERENCE_ELEMENT = "transformer";
    public static final String ANNOTATION_ELEMENT = "annotations";
    public static final String CONFIGURATION_ELEMENT = "configuration";
    public static final String DATA_WEAVE = "weave";
    public static final String CUSTOM_TRANSFORMER = "custom-transformer";
    public static final String DESCRIPTION_ELEMENT = "description";
    public static final String PROPERTIES_ELEMENT = "properties";
    public static final String FLOW_ELEMENT = "flow";
    public static final String FLOW_REF_ELEMENT = "flow-ref";
    public static final String SUBFLOW_ELEMENT = "sub-flow";
    private static final String MODULE_OPERATION_CHAIN_ELEMENT = "module-operation-chain";
    public static final String REDELIVERY_POLICY_ELEMENT = "redelivery-policy";
    public static final String TEST_NAMESPACE = "test";
    public static final String DOC_NAMESPACE = "doc";
    public static final String SPRING_SECURITY_NAMESPACE = "ss";
    public static final String MULE_SECURITY_NAMESPACE = "mule-ss";
    public static final String MULE_XML_NAMESPACE = "mulexml";
    public static final String PGP_NAMESPACE = "pgp";
    public static final String XSL_NAMESPACE = "xsl";
    public static final String TRANSPORT_NAMESPACE = "transports";
    public static final String JMS_NAMESPACE = "jms";
    public static final String VM_NAMESPACE = "vm";
    public static final String HTTP_TRANSPORT_NAMESPACE = "http-transport";
    public static final String BATCH_NAMESPACE = "batch";
    public static final String PARSER_TEST_NAMESPACE = "parsers-test";
    public static final String GLOBAL_PROPERTY = "global-property";
    public static final String SECURITY_MANAGER = "security-manager";
    public static final String CONFIGURATION_PROPERTIES_ELEMENT = "configuration-properties";
    public static final String OBJECT_ELEMENT = "object";
    public static final ComponentIdentifier ERROR_HANDLER_IDENTIFIER = ComponentIdentifier.builder().withNamespace("mule").withName("error-handler").build();
    public static final ComponentIdentifier EXCEPTION_STRATEGY_REFERENCE_IDENTIFIER = ComponentIdentifier.builder().withNamespace("mule").withName("exception-strategy").build();
    public static final ComponentIdentifier ERROR_MAPPING_IDENTIFIER = ComponentIdentifier.builder().withNamespace("mule").withName("error-mapping").build();
    public static final ComponentIdentifier MULE_IDENTIFIER = ComponentIdentifier.builder().withNamespace("mule").withName("mule").build();
    public static final ComponentIdentifier MULE_DOMAIN_IDENTIFIER = ComponentIdentifier.builder().withNamespace("domain").withName("mule-domain").build();
    public static final ComponentIdentifier MULE_EE_DOMAIN_IDENTIFIER = ComponentIdentifier.builder().withNamespace("ee-domain").withName("mule-domain").build();
    public static final ComponentIdentifier POLICY_IDENTIFIER = ComponentIdentifier.builder().withNamespace("policy").withName("policy").build();
    public static final ComponentIdentifier MULE_PROPERTY_IDENTIFIER = ComponentIdentifier.builder().withNamespace("mule").withName("property").build();
    public static final ComponentIdentifier MULE_PROPERTIES_IDENTIFIER = ComponentIdentifier.builder().withNamespace("mule").withName("properties").build();
    public static final ComponentIdentifier ANNOTATIONS_ELEMENT_IDENTIFIER = ComponentIdentifier.builder().withNamespace("mule").withName("annotations").build();
    public static final ComponentIdentifier PROCESSOR_IDENTIFIER = ComponentIdentifier.builder().withNamespace("mule").withName("processor").build();
    public static final ComponentIdentifier TRANSFORMER_IDENTIFIER = ComponentIdentifier.builder().withNamespace("mule").withName("transformer").build();
    public static final ComponentIdentifier CONFIGURATION_IDENTIFIER = ComponentIdentifier.builder().withNamespace("mule").withName("configuration").build();
    public static final ComponentIdentifier CUSTOM_TRANSFORMER_IDENTIFIER = ComponentIdentifier.builder().withNamespace("mule").withName("custom-transformer").build();
    public static final ComponentIdentifier DOC_DESCRIPTION_IDENTIFIER = ComponentIdentifier.builder().withNamespace("doc").withName("description").build();
    public static final ComponentIdentifier DESCRIPTION_IDENTIFIER = ComponentIdentifier.builder().withNamespace("mule").withName("description").build();
    public static final ComponentIdentifier ANNOTATIONS_IDENTIFIER = ComponentIdentifier.builder().withNamespace("mule").withName("annotations").build();
    public static final ComponentIdentifier OBJECT_IDENTIFIER = ComponentIdentifier.builder().withNamespace("mule").withName("object").build();
    public static final ComponentIdentifier FLOW_IDENTIFIER = ComponentIdentifier.builder().withNamespace("mule").withName("flow").build();
    public static final ComponentIdentifier FLOW_REF_IDENTIFIER = ComponentIdentifier.builder().withNamespace("mule").withName("flow-ref").build();
    public static final ComponentIdentifier SUBFLOW_IDENTIFIER = ComponentIdentifier.builder().withNamespace("mule").withName("sub-flow").build();
    public static final ComponentIdentifier REDELIVERY_POLICY_IDENTIFIER = ComponentIdentifier.builder().withNamespace("mule").withName("redelivery-policy").build();
    public static final ComponentIdentifier GLOBAL_PROPERTY_IDENTIFIER = ComponentIdentifier.builder().withNamespace("mule").withName("global-property").build();
    public static final ComponentIdentifier SECURITY_MANAGER_IDENTIFIER = ComponentIdentifier.builder().withNamespace("mule").withName("security-manager").build();
    public static final ComponentIdentifier CONFIGURATION_PROPERTIES = ComponentIdentifier.builder().withNamespace("mule").withName("configuration-properties").build();
    public static final ComponentIdentifier MODULE_OPERATION_CHAIN = ComponentIdentifier.builder().withNamespace("mule").withName("module-operation-chain").build();
    public static final String MUNIT_PREFIX = "munit";
    public static final ComponentIdentifier MUNIT_TEST_IDENTIFIER = ComponentIdentifier.builder().withNamespace("munit").withName("test").build();
    public static final ComponentIdentifier MUNIT_BEFORE_TEST_IDENTIFIER = ComponentIdentifier.builder().withNamespace("munit").withName("before-test").build();
    public static final ComponentIdentifier MUNIT_BEFORE_SUITE_IDENTIFIER = ComponentIdentifier.builder().withNamespace("munit").withName("before-suite").build();
    public static final ComponentIdentifier MUNIT_AFTER_TEST_IDENTIFIER = ComponentIdentifier.builder().withNamespace("munit").withName("after-test").build();
    public static final ComponentIdentifier MUNIT_AFTER_SUITE_IDENTIFIER = ComponentIdentifier.builder().withNamespace("munit").withName("after-suite").build();
    public static final String CLASS_ATTRIBUTE = "class";
    private static ImmutableSet<ComponentIdentifier> ignoredNameValidationComponentList = ImmutableSet.builder().add((Object)ComponentIdentifier.builder().withNamespace("mule").withName("flow-ref").build()).add((Object)ComponentIdentifier.builder().withNamespace("mule").withName("alias").build()).add((Object)ComponentIdentifier.builder().withNamespace("mule").withName("password-encryption-strategy").build()).add((Object)ComponentIdentifier.builder().withNamespace("mule").withName("custom-security-provider").build()).add((Object)ComponentIdentifier.builder().withNamespace("mule").withName("custom-encryption-strategy").build()).add((Object)ComponentIdentifier.builder().withNamespace("mule").withName("secret-key-encryption-strategy").build()).add((Object)ComponentIdentifier.builder().withNamespace("mule").withName("import").build()).add((Object)ComponentIdentifier.builder().withNamespace("mule").withName("string-to-byte-array-transformer").build()).add((Object)ComponentIdentifier.builder().withNamespace("mule").withName("append-string-transformer").build()).add((Object)ComponentIdentifier.builder().withNamespace("mule").withName("security-manager").build()).add((Object)ComponentIdentifier.builder().withNamespace("test").withName("queue").build()).add((Object)ComponentIdentifier.builder().withNamespace("test").withName("invocation-counter").build()).add((Object)ComponentIdentifier.builder().withNamespace("ss").withName("user").build()).add((Object)ComponentIdentifier.builder().withNamespace("mule-ss").withName("delegate-security-provider").build()).add((Object)ComponentIdentifier.builder().withNamespace("mule-ss").withName("security-manager").build()).add((Object)ComponentIdentifier.builder().withNamespace("mulexml").withName("xslt-transformer").build()).add((Object)ComponentIdentifier.builder().withNamespace("mulexml").withName("alias").build()).add((Object)ComponentIdentifier.builder().withNamespace("pgp").withName("security-provider").build()).add((Object)ComponentIdentifier.builder().withNamespace("pgp").withName("keybased-encryption-strategy").build()).add((Object)ComponentIdentifier.builder().withNamespace("xsl").withName("param").build()).add((Object)ComponentIdentifier.builder().withNamespace("xsl").withName("attribute").build()).add((Object)ComponentIdentifier.builder().withNamespace("xsl").withName("element").build()).add((Object)ComponentIdentifier.builder().withNamespace("transports").withName("inbound-endpoint").build()).add((Object)ComponentIdentifier.builder().withNamespace("transports").withName("outbound-endpoint").build()).add((Object)ComponentIdentifier.builder().withNamespace("jms").withName("inbound-endpoint").build()).add((Object)ComponentIdentifier.builder().withNamespace("vm").withName("inbound-endpoint").build()).add((Object)ComponentIdentifier.builder().withNamespace("http-transport").withName("inbound-endpoint").build()).add((Object)ComponentIdentifier.builder().withNamespace("http-transport").withName("set-cookie").build()).add((Object)ComponentIdentifier.builder().withNamespace("http-transport").withName("header").build()).add((Object)ComponentIdentifier.builder().withNamespace("http-transport").withName("http-response-to-object-transformer").build()).add((Object)ComponentIdentifier.builder().withNamespace("http-transport").withName("http-response-to-string-transformer").build()).add((Object)ComponentIdentifier.builder().withNamespace("http-transport").withName("message-to-http-response-transformer").build()).add((Object)ComponentIdentifier.builder().withNamespace("http-transport").withName("object-to-http-request-transformer").build()).add((Object)ComponentIdentifier.builder().withNamespace("batch").withName("step").build()).add((Object)ComponentIdentifier.builder().withNamespace("batch").withName("execute").build()).add((Object)ComponentIdentifier.builder().withNamespace("parsers-test").withName("child").build()).add((Object)ComponentIdentifier.builder().withNamespace("parsers-test").withName("kid").build()).add((Object)ComponentIdentifier.builder().withNamespace("weave").withName("reader-property").build()).build();
    private final Optional<ComponentBuildingDefinitionRegistry> componentBuildingDefinitionRegistry;
    private List<ComponentModel> muleComponentModels = new LinkedList<ComponentModel>();
    private PropertiesResolverConfigurationProperties configurationProperties;
    private ResourceProvider externalResourceProvider;

    public ApplicationModel(ArtifactConfig artifactConfig, ArtifactDeclaration artifactDeclaration, ResourceProvider externalResourceProvider) throws Exception {
        this(artifactConfig, artifactDeclaration, Collections.emptySet(), Collections.emptyMap(), Optional.empty(), Optional.of(new ComponentBuildingDefinitionRegistry()), true, externalResourceProvider);
    }

    public ApplicationModel(ArtifactConfig artifactConfig, ArtifactDeclaration artifactDeclaration, Set<ExtensionModel> extensionModels, Map<String, String> deploymentProperties, Optional<ConfigurationProperties> parentConfigurationProperties, Optional<ComponentBuildingDefinitionRegistry> componentBuildingDefinitionRegistry, boolean runtimeMode, ResourceProvider externalResourceProvider) throws Exception {
        this.componentBuildingDefinitionRegistry = componentBuildingDefinitionRegistry;
        this.externalResourceProvider = externalResourceProvider;
        this.createConfigurationAttributeResolver(artifactConfig, parentConfigurationProperties, deploymentProperties);
        this.convertConfigFileToComponentModel(artifactConfig);
        this.convertArtifactDeclarationToComponentModel(extensionModels, artifactDeclaration);
        this.validateModel(componentBuildingDefinitionRegistry);
        this.createEffectiveModel();
        if (runtimeMode) {
            this.expandModules(extensionModels);
        }
        this.resolveComponentTypes();
        this.executeOnEveryMuleComponentTree(new ComponentLocationVisitor());
    }

    private void createConfigurationAttributeResolver(ArtifactConfig artifactConfig, final Optional<ConfigurationProperties> parentConfigurationProperties, Map<String, String> deploymentProperties) {
        SystemPropertiesConfigurationProvider systemPropertiesConfigurationProvider = new SystemPropertiesConfigurationProvider();
        DefaultConfigurationPropertiesResolver localResolver = new DefaultConfigurationPropertiesResolver(Optional.empty(), systemPropertiesConfigurationProvider);
        List<ConfigurationPropertiesProvider> configConfigurationPropertiesProviders = this.getConfigurationPropertiesProvidersFromComponents(artifactConfig, localResolver);
        FileConfigurationPropertiesProvider externalPropertiesConfigurationProvider = new FileConfigurationPropertiesProvider(this.externalResourceProvider, "External files");
        Optional<ConfigurationPropertiesResolver> parentConfigurationPropertiesResolver = Optional.of(localResolver);
        if (parentConfigurationProperties.isPresent()) {
            parentConfigurationPropertiesResolver = Optional.of(new DefaultConfigurationPropertiesResolver(Optional.empty(), new ConfigurationPropertiesProvider(){

                @Override
                public Optional<ConfigurationProperty> getConfigurationProperty(String configurationAttributeKey) {
                    return ((ConfigurationProperties)parentConfigurationProperties.get()).resolveProperty(configurationAttributeKey).map(value -> new ConfigurationProperty(parentConfigurationProperties, configurationAttributeKey, value));
                }

                @Override
                public String getDescription() {
                    return "Domain properties";
                }
            }));
        }
        if (!configConfigurationPropertiesProviders.isEmpty()) {
            CompositeConfigurationPropertiesProvider configurationAttributesProvider = new CompositeConfigurationPropertiesProvider(configConfigurationPropertiesProviders);
            parentConfigurationPropertiesResolver = Optional.of(new DefaultConfigurationPropertiesResolver(parentConfigurationPropertiesResolver, configurationAttributesProvider));
        }
        ConfigurationPropertiesProvider globalPropertiesConfigurationAttributeProvider = this.createProviderFromGlobalProperties(artifactConfig);
        DefaultConfigurationPropertiesResolver globalPropertiesConfigurationPropertiesResolver = new DefaultConfigurationPropertiesResolver(parentConfigurationPropertiesResolver, globalPropertiesConfigurationAttributeProvider);
        DefaultConfigurationPropertiesResolver systemPropertiesResolver = new DefaultConfigurationPropertiesResolver(Optional.of(globalPropertiesConfigurationPropertiesResolver), systemPropertiesConfigurationProvider);
        DefaultConfigurationPropertiesResolver externalPropertiesResolver = new DefaultConfigurationPropertiesResolver(Optional.of(systemPropertiesResolver), externalPropertiesConfigurationProvider);
        this.configurationProperties = deploymentProperties.isEmpty() ? new PropertiesResolverConfigurationProperties(externalPropertiesResolver) : new PropertiesResolverConfigurationProperties(new DefaultConfigurationPropertiesResolver(Optional.of(externalPropertiesResolver), new MapConfigurationPropertiesProvider(deploymentProperties, "Deployment properties")));
    }

    private List<ConfigurationPropertiesProvider> getConfigurationPropertiesProvidersFromComponents(ArtifactConfig artifactConfig, DefaultConfigurationPropertiesResolver localResolver) {
        ArrayList<ConfigurationPropertiesProvider> configConfigurationPropertiesProviders = new ArrayList<ConfigurationPropertiesProvider>();
        artifactConfig.getConfigFiles().stream().forEach(configFile -> configFile.getConfigLines().stream().forEach(configLine -> {
            for (ConfigLine componentConfigLine : configLine.getChildren()) {
                if (componentConfigLine.getNamespace() == null || !componentConfigLine.getNamespace().equals(MULE_ROOT_ELEMENT) || !componentConfigLine.getIdentifier().equals(CONFIGURATION_PROPERTIES_ELEMENT)) continue;
                String fileLocation = componentConfigLine.getConfigAttributes().get("file").getValue();
                ConfigurationPropertiesComponent propertiesComponent = new ConfigurationPropertiesComponent(localResolver.resolveValue(fileLocation).toString(), this.externalResourceProvider);
                DefaultComponentLocation.DefaultLocationPart locationPart = new DefaultComponentLocation.DefaultLocationPart(CONFIGURATION_PROPERTIES_ELEMENT, Optional.of(TypedComponentIdentifier.builder().withType(TypedComponentIdentifier.ComponentType.UNKNOWN).withIdentifier(CONFIGURATION_PROPERTIES).build()), Optional.of(configFile.getFilename()), Optional.of(configLine.getLineNumber()));
                propertiesComponent.setAnnotations((Map<QName, Object>)ImmutableMap.builder().put((Object)AbstractAnnotatedObject.LOCATION_KEY, (Object)new DefaultComponentLocation(Optional.of(CONFIGURATION_PROPERTIES_ELEMENT), Collections.singletonList(locationPart))).build());
                configConfigurationPropertiesProviders.add(propertiesComponent);
                try {
                    propertiesComponent.initialise();
                }
                catch (InitialisationException e) {
                    throw new MuleRuntimeException(e);
                }
            }
        }));
        return configConfigurationPropertiesProviders;
    }

    public void resolveComponentTypes() {
        Preconditions.checkState(this.componentBuildingDefinitionRegistry.isPresent(), "ApplicationModel was created without a " + ComponentBuildingDefinitionProvider.class.getName());
        this.executeOnEveryComponentTree(componentModel -> {
            Optional<ComponentBuildingDefinition<?>> buildingDefinition = this.componentBuildingDefinitionRegistry.get().getBuildingDefinition(componentModel.getIdentifier());
            buildingDefinition.map(definition -> {
                ObjectTypeVisitor typeDefinitionVisitor = new ObjectTypeVisitor((ComponentModel)componentModel);
                definition.getTypeDefinition().visit(typeDefinitionVisitor);
                componentModel.setType(typeDefinitionVisitor.getType());
                return definition;
            }).orElseGet(() -> {
                String classParameter = componentModel.getParameters().get(CLASS_ATTRIBUTE);
                if (classParameter != null) {
                    try {
                        componentModel.setType(ClassUtils.getClass((String)classParameter));
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeConfigurationException(I18nMessageFactory.createStaticMessage(String.format("Could not resolve class '%s' for component '%s'", classParameter, componentModel.getComponentLocation())));
                    }
                }
                return null;
            });
        });
    }

    private void createEffectiveModel() {
        this.processSourcesRedeliveryPolicy();
    }

    private void processSourcesRedeliveryPolicy() {
        this.executeOnEveryFlow(flowComponentModel -> {
            if (!flowComponentModel.getInnerComponents().isEmpty()) {
                ComponentModel possibleSourceComponent = flowComponentModel.getInnerComponents().get(0);
                possibleSourceComponent.getInnerComponents().stream().filter(childComponent -> childComponent.getIdentifier().equals(REDELIVERY_POLICY_IDENTIFIER)).findAny().ifPresent(redeliveryPolicyComponentModel -> {
                    possibleSourceComponent.getInnerComponents().remove(redeliveryPolicyComponentModel);
                    flowComponentModel.getInnerComponents().add(1, (ComponentModel)redeliveryPolicyComponentModel);
                });
            }
        });
    }

    private void convertArtifactDeclarationToComponentModel(Set<ExtensionModel> extensionModels, ArtifactDeclaration artifactDeclaration) {
        if (artifactDeclaration != null && !extensionModels.isEmpty()) {
            DslElementModelFactory elementFactory = DslElementModelFactory.getDefault(DslResolvingContext.getDefault(extensionModels));
            ComponentModel rootComponent = new ComponentModel.Builder().setIdentifier(ComponentIdentifier.builder().withNamespace(MULE_ROOT_ELEMENT).withName(MULE_ROOT_ELEMENT).build()).build();
            AtomicBoolean atLeastOneComponentAdded = new AtomicBoolean(false);
            artifactDeclaration.getGlobalElements().stream().map(e -> elementFactory.create((ElementDeclaration)((Object)e))).filter(Optional::isPresent).map(e -> ((DslElementModel)e.get()).getConfiguration()).forEach(config -> config.ifPresent(c -> {
                atLeastOneComponentAdded.set(true);
                ComponentModel componentModel = this.convertComponentConfiguration((ComponentConfiguration)c, true);
                componentModel.setParent(rootComponent);
                rootComponent.getInnerComponents().add(componentModel);
            }));
            if (atLeastOneComponentAdded.get()) {
                this.muleComponentModels.add(rootComponent);
            }
        }
    }

    private ComponentModel convertComponentConfiguration(ComponentConfiguration componentConfiguration, boolean isRoot) {
        ComponentModel.Builder builder = new ComponentModel.Builder().setIdentifier(componentConfiguration.getIdentifier());
        if (isRoot) {
            builder.markAsRootComponent();
        }
        for (Map.Entry<String, String> parameter : componentConfiguration.getParameters().entrySet()) {
            builder.addParameter(parameter.getKey(), parameter.getValue(), false);
        }
        for (ComponentConfiguration childComponentConfiguration : componentConfiguration.getNestedComponents()) {
            builder.addChildComponentModel(this.convertComponentConfiguration(childComponentConfiguration, false));
        }
        componentConfiguration.getValue().ifPresent(builder::setTextContent);
        ComponentModel componentModel = builder.build();
        for (ComponentModel childComponent : componentModel.getInnerComponents()) {
            childComponent.setParent(componentModel);
        }
        return componentModel;
    }

    private ConfigurationPropertiesProvider createProviderFromGlobalProperties(ArtifactConfig artifactConfig) {
        HashMap<String, ConfigurationProperty> globalProperties = new HashMap<String, ConfigurationProperty>();
        artifactConfig.getConfigFiles().stream().forEach(configFile -> configFile.getConfigLines().get(0).getChildren().stream().forEach(configLine -> {
            if (GLOBAL_PROPERTY.equals(configLine.getIdentifier())) {
                String key = configLine.getConfigAttributes().get(NAME_ATTRIBUTE).getValue();
                String rawValue = configLine.getConfigAttributes().get(VALUE_ATTRIBUTE).getValue();
                globalProperties.put(key, new ConfigurationProperty(String.format("global-property - file: %s - lineNumber %s", configFile.getFilename(), configLine.getLineNumber()), key, rawValue));
            }
        }));
        return new GlobalPropertyConfigurationPropertiesProvider(globalProperties);
    }

    public ComponentModel findComponentDefinitionModel(Node element) {
        return this.innerFindComponentDefinitionModel(element, this.muleComponentModels);
    }

    public Optional<ComponentModel> findComponentDefinitionModel(ComponentIdentifier componentIdentifier) {
        if (this.muleComponentModels.isEmpty()) {
            return Optional.empty();
        }
        return this.muleComponentModels.get(0).getInnerComponents().stream().filter(ComponentModel::isRoot).filter(componentModel -> componentModel.getIdentifier().equals(componentIdentifier)).findFirst();
    }

    private void convertConfigFileToComponentModel(ArtifactConfig artifactConfig) {
        List<ConfigFile> configFiles = artifactConfig.getConfigFiles();
        ComponentModelReader componentModelReader = new ComponentModelReader(this.configurationProperties.getConfigurationPropertiesResolver());
        configFiles.stream().forEach(configFile -> {
            ComponentModel componentModel = componentModelReader.extractComponentDefinitionModel(configFile.getConfigLines().get(0), configFile.getFilename());
            if (this.muleComponentModels.isEmpty()) {
                this.muleComponentModels.add(componentModel);
            } else {
                ComponentModel rootComponentModel = this.muleComponentModels.get(0);
                this.muleComponentModels.set(0, new ComponentModel.Builder(rootComponentModel).merge(componentModel).build());
            }
        });
    }

    private void validateModel(Optional<ComponentBuildingDefinitionRegistry> componentBuildingDefinitionRegistry) throws ConfigurationException {
        if (this.muleComponentModels.isEmpty() || !this.isMuleConfigurationFile()) {
            return;
        }
        this.validateNameIsNotRepeated();
        this.validateErrorMappings();
        this.validateExceptionStrategyWhenAttributeIsOnlyPresentInsideChoice();
        this.validateErrorHandlerStructure();
        this.validateParameterAndChildForSameAttributeAreNotDefinedTogether();
        if (componentBuildingDefinitionRegistry.isPresent()) {
            this.validateNamedTopLevelElementsHaveName(componentBuildingDefinitionRegistry.get());
        }
        this.validateSingleElementsExistence();
    }

    private void validateParameterAndChildForSameAttributeAreNotDefinedTogether() {
        this.executeOnEveryMuleComponentTree(componentModel -> {
            for (String parameterName : componentModel.getParameters().keySet()) {
                if (componentModel.isParameterValueProvidedBySchema(parameterName)) continue;
                String mapChildName = NameUtils.hyphenize(NameUtils.pluralize(parameterName));
                String listOrPojoChildName = NameUtils.hyphenize(parameterName);
                Optional<ComponentModel> childOptional = this.findRelatedChildForParameter(componentModel.getInnerComponents(), mapChildName, listOrPojoChildName);
                if (!childOptional.isPresent()) continue;
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Component %s has a child element %s which is used for the same purpose of the configuration parameter %s. Only one must be used.", componentModel.getIdentifier(), childOptional.get().getIdentifier(), parameterName)));
            }
        });
    }

    private Optional<ComponentModel> findRelatedChildForParameter(List<ComponentModel> chilrenComponents, String ... possibleNames) {
        HashSet<String> possibleNamesSet = new HashSet<String>(Arrays.asList(possibleNames));
        for (ComponentModel childrenComponent : chilrenComponents) {
            if (!possibleNamesSet.contains(childrenComponent.getIdentifier().getName())) continue;
            return Optional.of(childrenComponent);
        }
        return Optional.empty();
    }

    private void validateNameIsNotRepeated() {
        HashMap existingObjectsWithName = new HashMap();
        this.executeOnEveryMuleComponentTree(componentModel -> {
            String nameAttributeValue = componentModel.getNameAttribute();
            if (nameAttributeValue != null && !ignoredNameValidationComponentList.contains((Object)componentModel.getIdentifier())) {
                if (existingObjectsWithName.containsKey(nameAttributeValue)) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Two configuration elements have been defined with the same global name. Global name [%s] must be unique. Clashing components are %s and %s", nameAttributeValue, ((ComponentModel)existingObjectsWithName.get(nameAttributeValue)).getIdentifier(), componentModel.getIdentifier()));
                }
                existingObjectsWithName.put(nameAttributeValue, componentModel);
            }
        });
    }

    private boolean isMuleConfigurationFile() {
        ComponentIdentifier rootIdentifier = this.muleComponentModels.get(0).getIdentifier();
        return rootIdentifier.equals(MULE_IDENTIFIER) || rootIdentifier.equals(MULE_DOMAIN_IDENTIFIER) || rootIdentifier.equals(MULE_EE_DOMAIN_IDENTIFIER);
    }

    private void validateErrorMappings() {
        this.executeOnEveryComponentTree(componentModel -> {
            List errorMappings = componentModel.getInnerComponents().stream().filter(c -> c.getIdentifier().equals(ERROR_MAPPING_IDENTIFIER)).collect(Collectors.toList());
            if (!errorMappings.isEmpty()) {
                List anyMappings = errorMappings.stream().filter(this::isErrorMappingWithSourceAny).collect(Collectors.toList());
                if (anyMappings.size() > 1) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Only one mapping for 'ANY' or an empty source type is allowed."));
                }
                if (anyMappings.size() == 1 && !this.isErrorMappingWithSourceAny((ComponentModel)errorMappings.get(errorMappings.size() - 1))) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Only the last error mapping can have 'ANY' or an empty source type."));
                }
                List sources = errorMappings.stream().map(model -> model.getParameters().get("sourceType")).collect(Collectors.toList());
                List distinctSources = sources.stream().distinct().collect(Collectors.toList());
                if (sources.size() != distinctSources.size()) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Repeated source types are not allowed. Offending types are '%s'.", Joiner.on((String)"', '").join((Iterable)CollectionUtils.disjunction(sources, distinctSources)))));
                }
            }
        });
    }

    private boolean isErrorMappingWithSourceAny(ComponentModel model) {
        String sourceType = model.getParameters().get("sourceType");
        return sourceType == null || sourceType.equals("ANY");
    }

    private void validateErrorHandlerStructure() {
        this.executeOnEveryMuleComponentTree(component -> {
            if (component.getIdentifier().equals(ERROR_HANDLER_IDENTIFIER)) {
                this.validateExceptionStrategiesHaveWhenAttribute((ComponentModel)component);
                this.validateNoMoreThanOneRollbackExceptionStrategyWithRedelivery((ComponentModel)component);
            }
        });
    }

    private void validateNoMoreThanOneRollbackExceptionStrategyWithRedelivery(ComponentModel component) {
        if (component.getInnerComponents().stream().filter(exceptionStrategyComponent -> exceptionStrategyComponent.getParameters().get(MAX_REDELIVERY_ATTEMPTS_ROLLBACK_ES_ATTRIBUTE) != null).count() > 1L) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Only one on-error-propagate within a error-handler can handle message redelivery. Remove one of the maxRedeliveryAttempts attributes"));
        }
    }

    private void validateExceptionStrategiesHaveWhenAttribute(ComponentModel component) {
        List<ComponentModel> innerComponents = component.getInnerComponents();
        for (int i = 0; i < innerComponents.size() - 1; ++i) {
            Map<String, String> parameters = innerComponents.get(i).getParameters();
            if (parameters.get(WHEN_CHOICE_ES_ATTRIBUTE) != null || parameters.get(TYPE_ES_ATTRIBUTE) != null) continue;
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Every handler (except for the last one) within an 'error-handler' must specify a 'when' or 'type' attribute."));
        }
    }

    private void validateExceptionStrategyWhenAttributeIsOnlyPresentInsideChoice() {
        this.executeOnEveryMuleComponentTree(component -> {
            if (component.getIdentifier().getName().endsWith(EXCEPTION_STRATEGY_REFERENCE_ELEMENT)) {
                Node componentNode = XmlCustomAttributeHandler.from(component).getNode();
                if (component.getParameters().get(WHEN_CHOICE_ES_ATTRIBUTE) != null && !componentNode.getParentNode().getLocalName().equals(ERROR_HANDLER) && !componentNode.getParentNode().getLocalName().equals(MULE_ROOT_ELEMENT)) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Only handlers within an error-handler can have when attribute specified"));
                }
            }
        });
    }

    private void validateNamedTopLevelElementsHaveName(ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry) throws ConfigurationException {
        try {
            List<ComponentModel> topLevelComponents = this.muleComponentModels.get(0).getInnerComponents();
            topLevelComponents.stream().forEach(topLevelComponent -> {
                ComponentIdentifier identifier = topLevelComponent.getIdentifier();
                componentBuildingDefinitionRegistry.getBuildingDefinition(identifier).filter(ComponentBuildingDefinition::isNamed).ifPresent(buildingDefinition -> {
                    if (StringUtils.isBlank((CharSequence)topLevelComponent.getNameAttribute())) {
                        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Global element %s:%s does not provide a name attribute.", identifier.getNamespace(), identifier.getName())));
                    }
                });
            });
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public void executeOnEveryComponentTree(Consumer<ComponentModel> task) {
        for (ComponentModel componentModel : this.muleComponentModels) {
            this.executeOnComponentTree(componentModel, task);
        }
    }

    public void executeOnEveryMuleComponentTree(Consumer<ComponentModel> task) {
        for (ComponentModel componentModel : this.muleComponentModels) {
            this.executeOnComponentTree(componentModel, task);
        }
    }

    public void executeOnEveryRootElement(Consumer<ComponentModel> task) {
        for (ComponentModel muleComponentModel : this.muleComponentModels) {
            for (ComponentModel componentModel : muleComponentModel.getInnerComponents()) {
                task.accept(componentModel);
            }
        }
    }

    public void executeOnEveryFlow(Consumer<ComponentModel> task) {
        this.executeOnEveryRootElement(componentModel -> {
            if (FLOW_IDENTIFIER.equals(componentModel.getIdentifier())) {
                task.accept((ComponentModel)componentModel);
            }
        });
    }

    private void executeOnComponentTree(ComponentModel component, Consumer<ComponentModel> task) throws MuleRuntimeException {
        task.accept(component);
        component.getInnerComponents().forEach(innerComponent -> this.executeOnComponentTree((ComponentModel)innerComponent, task));
    }

    private ComponentModel innerFindComponentDefinitionModel(Node element, List<ComponentModel> componentModels) {
        for (ComponentModel componentModel : componentModels) {
            if (XmlCustomAttributeHandler.from(componentModel).getNode().equals(element)) {
                return componentModel;
            }
            ComponentModel childComponentModel = this.innerFindComponentDefinitionModel(element, componentModel.getInnerComponents());
            if (childComponentModel == null) continue;
            return childComponentModel;
        }
        return null;
    }

    private void validateSingleElementsExistence() {
        this.validateSingleElementExistence(ComponentIdentifier.buildFromStringRepresentation("munit:before-suite"));
        this.validateSingleElementExistence(ComponentIdentifier.buildFromStringRepresentation("munit:after-suite"));
        this.validateSingleElementExistence(ComponentIdentifier.buildFromStringRepresentation("munit:before-test"));
        this.validateSingleElementExistence(ComponentIdentifier.buildFromStringRepresentation("munit:after-test"));
    }

    private void validateSingleElementExistence(ComponentIdentifier componentIdentifier) {
        HashMap existingObjectsWithName = new HashMap();
        this.executeOnEveryMuleComponentTree(componentModel -> {
            ComponentIdentifier identifier = componentModel.getIdentifier();
            if (componentIdentifier.getNamespace().equals(identifier.getNamespace()) && componentIdentifier.getName().equals(identifier.getName())) {
                if (existingObjectsWithName.containsKey(identifier)) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Two configuration elements %s have been defined. Element [%s] must be unique. Clashing components are %s and %s", identifier.getNamespace() + ":" + identifier.getName(), identifier.getNamespace() + ":" + identifier.getName(), componentModel.getNameAttribute(), ((ComponentModel)existingObjectsWithName.get(identifier)).getNameAttribute()));
                }
                existingObjectsWithName.put(identifier, componentModel);
            }
        });
    }

    public ComponentModel getRootComponentModel() {
        return this.muleComponentModels.get(0);
    }

    public Optional<ComponentModel> findTopLevelNamedComponent(String name) {
        ComponentModel muleComponentModel;
        Optional<ComponentModel> requestedComponentModelOptional = Optional.empty();
        Iterator<ComponentModel> iterator = this.muleComponentModels.iterator();
        while (iterator.hasNext() && !(requestedComponentModelOptional = (muleComponentModel = iterator.next()).getInnerComponents().stream().filter(componentModel -> name.equals(componentModel.getNameAttribute())).findAny()).isPresent()) {
        }
        return requestedComponentModelOptional;
    }

    public Optional<ComponentConfiguration> findTopLevelNamedElement(String name) {
        ComponentModel muleComponentModel;
        Optional<ComponentConfiguration> requestedElement = Optional.empty();
        Iterator<ComponentModel> iterator = this.muleComponentModels.iterator();
        while (iterator.hasNext() && !(requestedElement = (muleComponentModel = iterator.next()).getInnerComponents().stream().filter(componentModel -> name.equals(componentModel.getNameAttribute())).map(ComponentModel::getConfiguration).findAny()).isPresent()) {
        }
        return requestedElement;
    }

    private void expandModules(Set<ExtensionModel> extensionModels) {
        new MacroExpansionModuleModel(this, extensionModels).expand();
    }

    public ConfigurationProperties getConfigurationProperties() {
        return this.configurationProperties;
    }
}

