/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.dsl.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.config.spring.dsl.model.ApplicationModel;
import org.mule.runtime.config.spring.dsl.model.ComponentBuildingDefinitionRegistry;
import org.mule.runtime.config.spring.dsl.model.ComponentModel;
import org.mule.runtime.config.spring.dsl.model.NoSuchComponentModelException;
import org.mule.runtime.config.spring.dsl.processor.AbstractAttributeDefinitionVisitor;
import org.mule.runtime.dsl.api.component.KeyAttributeDefinitionPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinimalApplicationModelGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinimalApplicationModelGenerator.class);
    private final ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry;
    private final ApplicationModel applicationModel;

    public MinimalApplicationModelGenerator(ApplicationModel applicationModel, ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry) {
        this.applicationModel = applicationModel;
        this.componentBuildingDefinitionRegistry = componentBuildingDefinitionRegistry;
    }

    public ApplicationModel getMinimalModel(Location location) {
        ComponentModel requestedComponentModel = this.findRequiredComponentModel(location);
        Set<String> otherRequiredGlobalComponents = this.resolveComponentDependencies(requestedComponentModel);
        String requestComponentModelName = requestedComponentModel.getNameAttribute();
        if (requestComponentModelName != null && this.applicationModel.findTopLevelNamedElement(requestComponentModelName).isPresent()) {
            otherRequiredGlobalComponents.add(requestedComponentModel.getNameAttribute());
        }
        Set<String> allRequiredComponentModels = this.findComponentModelsDependencies(otherRequiredGlobalComponents);
        for (ComponentModel componentModel2 : this.applicationModel.getRootComponentModel().getInnerComponents()) {
            if (componentModel2.getNameAttribute() == null || !allRequiredComponentModels.contains(componentModel2.getNameAttribute())) continue;
            componentModel2.setEnabled(true);
            componentModel2.executedOnEveryInnerComponent(component -> component.setEnabled(true));
        }
        ComponentModel currentComponentModel = requestedComponentModel;
        for (ComponentModel parentModel = currentComponentModel.getParent(); parentModel != null && parentModel.getParent() != null; parentModel = parentModel.getParent()) {
            parentModel.setEnabled(true);
            for (ComponentModel innerComponent : parentModel.getInnerComponents()) {
                if (innerComponent.equals(currentComponentModel)) continue;
                innerComponent.setEnabled(false);
                innerComponent.executedOnEveryInnerComponent(component -> component.setEnabled(false));
            }
            currentComponentModel = parentModel;
        }
        requestedComponentModel.setEnabled(true);
        requestedComponentModel.executedOnEveryInnerComponent(componentModel -> componentModel.setEnabled(true));
        this.applicationModel.getRootComponentModel().setEnabled(true);
        return this.applicationModel;
    }

    public List<ComponentModel> resolveComponentModelDependencies() {
        LinkedHashMap<ComponentModel, List<ComponentModel>> componentModelDependencies = new LinkedHashMap<ComponentModel, List<ComponentModel>>();
        this.applicationModel.executeOnEveryMuleComponentTree(componentModel -> {
            if (componentModel.getNameAttribute() != null && componentModel.isEnabled()) {
                List dependencies = this.resolveComponentModelDependencies((ComponentModel)componentModel).stream().map(componentModelName -> this.applicationModel.findTopLevelNamedComponent((String)componentModelName).get()).collect(Collectors.toList());
                componentModelDependencies.put((ComponentModel)componentModel, dependencies);
            }
        });
        ArrayList<ComponentModel> used = new ArrayList<ComponentModel>();
        ArrayList<ComponentModel> sorted = new ArrayList<ComponentModel>();
        for (ComponentModel componentModel2 : componentModelDependencies.keySet()) {
            if (used.contains(componentModel2)) continue;
            this.resolveDependency(componentModelDependencies, used, sorted, componentModel2);
        }
        Collections.reverse(sorted);
        return sorted;
    }

    private void resolveDependency(Map<ComponentModel, List<ComponentModel>> allDependencies, List<ComponentModel> used, List<ComponentModel> sortedComponentModel, ComponentModel componentModel) {
        used.add(componentModel);
        for (ComponentModel dependency : allDependencies.get(componentModel)) {
            if (used.contains(componentModel)) continue;
            this.resolveDependency(allDependencies, used, sortedComponentModel, dependency);
        }
        sortedComponentModel.add(componentModel);
    }

    private Set<String> resolveComponentModelDependencies(ComponentModel componentModel) {
        Set<String> otherRequiredGlobalComponents = this.resolveComponentDependencies(componentModel);
        return this.findComponentModelsDependencies(otherRequiredGlobalComponents);
    }

    private ComponentModel findRequiredComponentModel(String name) {
        return this.applicationModel.findTopLevelNamedComponent(name).orElseThrow(() -> new NoSuchComponentModelException(I18nMessageFactory.createStaticMessage("No named component with name " + name)));
    }

    private ComponentModel findRequiredComponentModel(Location location) {
        Reference foundComponentModelReference = new Reference();
        Optional<ComponentModel> globalComponent = this.applicationModel.findTopLevelNamedComponent(location.getGlobalElementName());
        globalComponent.ifPresent(componentModel -> this.findComponentWithLocation((ComponentModel)componentModel, location).ifPresent(foundComponentModel -> foundComponentModelReference.set(foundComponentModel)));
        if (foundComponentModelReference.get() == null) {
            throw new NoSuchComponentModelException(I18nMessageFactory.createStaticMessage("No object found at location " + location.toString()));
        }
        return (ComponentModel)foundComponentModelReference.get();
    }

    private Optional<ComponentModel> findComponentWithLocation(ComponentModel componentModel, Location location) {
        if (componentModel.getComponentLocation().getLocation().equals(location.toString())) {
            return Optional.of(componentModel);
        }
        for (ComponentModel childComponent : componentModel.getInnerComponents()) {
            Optional<ComponentModel> foundComponent = this.findComponentWithLocation(childComponent, location);
            if (!foundComponent.isPresent()) continue;
            return foundComponent;
        }
        return Optional.empty();
    }

    private Set<String> findComponentModelsDependencies(Set<String> componentModelNames) {
        Set<String> componentsToSearchDependencies = componentModelNames;
        LinkedHashSet<String> foundDependencies = new LinkedHashSet<String>();
        HashSet<String> alreadySearchedDependencies = new HashSet<String>();
        do {
            componentsToSearchDependencies.addAll(foundDependencies);
            for (String componentModelName : componentsToSearchDependencies) {
                if (alreadySearchedDependencies.contains(componentModelName)) continue;
                alreadySearchedDependencies.add(componentModelName);
                foundDependencies.addAll(this.resolveComponentDependencies(this.findRequiredComponentModel(componentModelName)));
            }
            foundDependencies.addAll(componentModelNames);
        } while (!foundDependencies.containsAll(componentsToSearchDependencies));
        return foundDependencies;
    }

    private Set<String> resolveComponentDependencies(ComponentModel requestedComponentModel) {
        HashSet<String> otherDependencies = new HashSet<String>();
        requestedComponentModel.getInnerComponents().stream().forEach(childComponent -> otherDependencies.addAll(this.resolveComponentDependencies((ComponentModel)childComponent)));
        final HashSet parametersReferencingDependencies = new HashSet();
        this.componentBuildingDefinitionRegistry.getBuildingDefinition(requestedComponentModel.getIdentifier()).ifPresent(buildingDefinition -> buildingDefinition.getAttributesDefinitions().stream().forEach(attributeDefinition -> attributeDefinition.accept(new AbstractAttributeDefinitionVisitor(){

            @Override
            public void onMultipleValues(KeyAttributeDefinitionPair[] definitions) {
                Arrays.stream(definitions).forEach(keyAttributeDefinitionPair -> keyAttributeDefinitionPair.getAttributeDefinition().accept(this));
            }

            @Override
            public void onReferenceSimpleParameter(String reference) {
                parametersReferencingDependencies.add(reference);
            }
        })));
        for (String parametersReferencingDependency : parametersReferencingDependencies) {
            if (requestedComponentModel.getParameters().containsKey(parametersReferencingDependency)) {
                this.appendDependency(otherDependencies, requestedComponentModel, parametersReferencingDependency);
                continue;
            }
            if (!this.isFlowRef(requestedComponentModel.getIdentifier())) continue;
            this.appendDependency(otherDependencies, requestedComponentModel, "name");
        }
        return otherDependencies;
    }

    private void appendDependency(Set<String> otherDependencies, ComponentModel requestedComponentModel, String parametersReferencingDependency) {
        String name = requestedComponentModel.getParameters().get(parametersReferencingDependency);
        if (this.applicationModel.findTopLevelNamedElement(name).isPresent()) {
            otherDependencies.add(name);
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Ignoring dependency %s because it does not exists", name));
        }
    }

    private boolean isFlowRef(ComponentIdentifier componentIdentifier) {
        return componentIdentifier.getNamespace().equals("mule") && componentIdentifier.getName().equals("flow-ref");
    }
}

