/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.dsl.model.extension.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.config.spring.dsl.model.ApplicationModel;
import org.mule.runtime.config.spring.dsl.model.ComponentModel;
import org.mule.runtime.config.spring.dsl.model.extension.xml.GlobalElementComponentModelModelProperty;
import org.mule.runtime.config.spring.dsl.model.extension.xml.OperationComponentModelModelProperty;
import org.mule.runtime.config.spring.dsl.model.extension.xml.XmlExtensionModelProperty;

public class MacroExpansionModuleModel {
    private static final String MODULE_OPERATION_CONFIG_REF = "config-ref";
    public static final String ORIGINAL_IDENTIFIER = "ORIGINAL_IDENTIFIER";
    private final ApplicationModel applicationModel;
    private final List<ExtensionModel> extensions;

    public MacroExpansionModuleModel(ApplicationModel applicationModel, Set<ExtensionModel> extensions) {
        this.applicationModel = applicationModel;
        this.extensions = extensions.stream().filter(extensionModel -> extensionModel.getModelProperty(XmlExtensionModelProperty.class).isPresent()).collect(Collectors.toList());
    }

    public void expand() {
        for (int i = 0; i < this.extensions.size(); ++i) {
            for (ExtensionModel extensionModel : this.extensions) {
                this.expand(extensionModel);
            }
        }
    }

    private void expand(ExtensionModel extensionModel) {
        List<ComponentModel> moduleGlobalElements = this.getModuleGlobalElements(extensionModel);
        Set<String> moduleGlobalElementsNames = moduleGlobalElements.stream().map(ComponentModel::getNameAttribute).collect(Collectors.toSet());
        this.createOperationRefEffectiveModel(extensionModel, moduleGlobalElementsNames);
        this.createConfigRefEffectiveModel(extensionModel, moduleGlobalElements, moduleGlobalElementsNames);
    }

    private void createOperationRefEffectiveModel(ExtensionModel extensionModel, Set<String> moduleGlobalElementsNames) {
        HashMap componentModelsToReplaceByIndex = new HashMap();
        this.applicationModel.executeOnEveryMuleComponentTree(flowComponentModel -> {
            for (int i = 0; i < flowComponentModel.getInnerComponents().size(); ++i) {
                Optional<OperationModel> operationModel;
                ComponentModel operationRefModel = flowComponentModel.getInnerComponents().get(i);
                ComponentIdentifier identifier = operationRefModel.getIdentifier();
                String identifierName = identifier.getName();
                if (identifierName.equals("config") || !extensionModel.getXmlDslModel().getPrefix().equals(identifier.getNamespace())) continue;
                HasOperationModels hasOperationModels = extensionModel;
                Optional<ConfigurationModel> configurationModel = extensionModel.getConfigurationModel("config");
                if (configurationModel.isPresent()) {
                    hasOperationModels = configurationModel.get();
                }
                if ((operationModel = hasOperationModels.getOperationModel(identifierName)).isPresent()) {
                    ComponentModel replacementModel = this.createOperationInstance(operationRefModel, extensionModel, operationModel.get(), moduleGlobalElementsNames);
                    componentModelsToReplaceByIndex.put(i, replacementModel);
                    continue;
                }
                ComponentIdentifier parentIdentifier = operationRefModel.getParent().getIdentifier();
                String parentIdentifierName = parentIdentifier.getName();
                if (hasOperationModels.getOperationModel(parentIdentifierName).isPresent()) continue;
                throw new IllegalArgumentException(String.format("The operation '%s' is missing in the module '%s'", identifierName, extensionModel.getName()));
            }
            for (Map.Entry entry : componentModelsToReplaceByIndex.entrySet()) {
                ((ComponentModel)entry.getValue()).setParent((ComponentModel)flowComponentModel);
                flowComponentModel.getInnerComponents().add((Integer)entry.getKey(), (ComponentModel)entry.getValue());
                flowComponentModel.getInnerComponents().remove((Integer)entry.getKey() + 1);
            }
            componentModelsToReplaceByIndex.clear();
        });
    }

    private void createConfigRefEffectiveModel(ExtensionModel extensionModel, List<ComponentModel> moduleComponentModels, Set<String> moduleGlobalElementsNames) {
        this.applicationModel.executeOnEveryMuleComponentTree(componentModel -> {
            HashMap<ComponentModel, List<ComponentModel>> componentModelsToReplaceByIndex = new HashMap<ComponentModel, List<ComponentModel>>();
            for (int i = 0; i < componentModel.getInnerComponents().size(); ++i) {
                ComponentModel configRefModel = componentModel.getInnerComponents().get(i);
                ComponentIdentifier identifier = configRefModel.getIdentifier();
                if (!extensionModel.getXmlDslModel().getPrefix().equals(identifier.getNamespace())) continue;
                Map<String, String> propertiesMap = this.extractParameters(configRefModel, extensionModel.getConfigurationModel("config").get().getAllParameterModels());
                Map<String, String> literalsParameters = this.getLiteralParameters(propertiesMap, Collections.emptyMap());
                List<ComponentModel> replacementGlobalElements = this.createGlobalElementsInstance(configRefModel, moduleComponentModels, moduleGlobalElementsNames, literalsParameters);
                componentModelsToReplaceByIndex.put(configRefModel, replacementGlobalElements);
            }
            for (Map.Entry entry : componentModelsToReplaceByIndex.entrySet()) {
                int componentModelIndex = componentModel.getInnerComponents().indexOf(entry.getKey());
                componentModel.getInnerComponents().addAll(componentModelIndex, (Collection)entry.getValue());
                componentModel.getInnerComponents().remove(componentModelIndex + ((List)entry.getValue()).size());
            }
        });
    }

    private List<ComponentModel> createGlobalElementsInstance(ComponentModel configRefModel, List<ComponentModel> moduleGlobalElements, Set<String> moduleGlobalElementsNames, Map<String, String> literalsParameters) {
        ArrayList<ComponentModel> globalElementsModel = new ArrayList<ComponentModel>();
        globalElementsModel.addAll(moduleGlobalElements.stream().map(globalElementModel -> this.copyComponentModel((ComponentModel)globalElementModel, configRefModel.getNameAttribute(), moduleGlobalElementsNames, literalsParameters)).collect(Collectors.toList()));
        ComponentModel muleRootElement = configRefModel.getParent();
        globalElementsModel.stream().forEach(componentModel -> {
            componentModel.setRoot(true);
            componentModel.setParent(muleRootElement);
        });
        return globalElementsModel;
    }

    private List<ComponentModel> getModuleGlobalElements(ExtensionModel extensionModel) {
        List<ComponentModel> moduleGlobalElements = new ArrayList<ComponentModel>();
        Optional<ConfigurationModel> config = extensionModel.getConfigurationModel("config");
        if (config.isPresent() && config.get().getModelProperty(GlobalElementComponentModelModelProperty.class).isPresent()) {
            GlobalElementComponentModelModelProperty globalElementComponentModelModelProperty = config.get().getModelProperty(GlobalElementComponentModelModelProperty.class).get();
            moduleGlobalElements = globalElementComponentModelModelProperty.getGlobalElements();
        }
        return moduleGlobalElements;
    }

    private ComponentModel createOperationInstance(ComponentModel operationRefModel, ExtensionModel extensionModel, OperationModel operationModel, Set<String> moduleGlobalElementsNames) {
        OperationComponentModelModelProperty operationComponentModelModelProperty = operationModel.getModelProperty(OperationComponentModelModelProperty.class).get();
        ComponentModel operationModuleComponentModel = operationComponentModelModelProperty.getBodyComponentModel();
        List<ComponentModel> bodyProcessors = operationModuleComponentModel.getInnerComponents();
        String configRefName = operationRefModel.getParameters().get(MODULE_OPERATION_CONFIG_REF);
        ComponentModel.Builder processorChainBuilder = new ComponentModel.Builder();
        processorChainBuilder.setIdentifier(ComponentIdentifier.builder().withNamespace("mule").withName("module-operation-chain").build());
        processorChainBuilder.addParameter("moduleName", extensionModel.getXmlDslModel().getPrefix(), false);
        processorChainBuilder.addParameter("moduleOperation", operationModel.getName(), false);
        Map<String, String> propertiesMap = this.extractProperties(operationRefModel, extensionModel);
        Map<String, String> parametersMap = this.extractParameters(operationRefModel, operationModel.getAllParameterModels());
        ComponentModel propertiesComponentModel = this.getParameterChild(propertiesMap, "module-operation-properties", "module-operation-property-entry");
        ComponentModel parametersComponentModel = this.getParameterChild(parametersMap, "module-operation-parameters", "module-operation-parameter-entry");
        processorChainBuilder.addChildComponentModel(propertiesComponentModel);
        processorChainBuilder.addChildComponentModel(parametersComponentModel);
        Map<String, String> literalsParameters = this.getLiteralParameters(propertiesMap, parametersMap);
        for (ComponentModel componentModel : bodyProcessors) {
            processorChainBuilder.addChildComponentModel(this.copyComponentModel(componentModel, configRefName, moduleGlobalElementsNames, literalsParameters));
        }
        for (Map.Entry entry : operationRefModel.getCustomAttributes().entrySet()) {
            processorChainBuilder.addCustomAttribute((String)entry.getKey(), entry.getValue());
        }
        ComponentModel processorChainModel = processorChainBuilder.build();
        for (ComponentModel processorChainModelChild : processorChainModel.getInnerComponents()) {
            processorChainModelChild.setParent(processorChainModel);
        }
        operationRefModel.getConfigFileName().ifPresent(processorChainBuilder::setConfigFileName);
        operationRefModel.getLineNumber().ifPresent(processorChainBuilder::setLineNumber);
        processorChainBuilder.addCustomAttribute(ORIGINAL_IDENTIFIER, operationRefModel.getIdentifier());
        return processorChainModel;
    }

    private Map<String, String> getLiteralParameters(Map<String, String> propertiesMap, Map<String, String> parametersMap) {
        Map<String, String> literalsParameters = propertiesMap.entrySet().stream().filter(entry -> !this.isExpression((String)entry.getValue())).collect(Collectors.toMap(e -> this.getReplaceableExpression((String)e.getKey(), "properties"), Map.Entry::getValue));
        literalsParameters.putAll(parametersMap.entrySet().stream().filter(entry -> !this.isExpression((String)entry.getValue())).collect(Collectors.toMap(e -> this.getReplaceableExpression((String)e.getKey(), "parameters"), Map.Entry::getValue)));
        return literalsParameters;
    }

    private String getReplaceableExpression(String name, String prefix) {
        return "#[" + prefix + "." + name + "]";
    }

    private boolean isExpression(String value) {
        return value.startsWith("#[") && value.endsWith("]");
    }

    private ComponentModel getParameterChild(Map<String, String> parameters, String wrapperParameters, String entryParameter) {
        ComponentModel.Builder parametersBuilder = new ComponentModel.Builder();
        parametersBuilder.setIdentifier(ComponentIdentifier.builder().withNamespace("mule").withName(wrapperParameters).build());
        parameters.forEach((paramName, paramValue) -> {
            ComponentModel.Builder parameterBuilder = new ComponentModel.Builder();
            parameterBuilder.setIdentifier(ComponentIdentifier.builder().withNamespace("mule").withName(entryParameter).build());
            parameterBuilder.addParameter("key", (String)paramName, false);
            parameterBuilder.addParameter("value", (String)paramValue, false);
            parametersBuilder.addChildComponentModel(parameterBuilder.build());
        });
        ComponentModel parametersComponentModel = parametersBuilder.build();
        for (ComponentModel parameterComponentModel : parametersComponentModel.getInnerComponents()) {
            parameterComponentModel.setParent(parametersComponentModel);
        }
        return parametersComponentModel;
    }

    private Map<String, String> extractProperties(ComponentModel operationRefModel, ExtensionModel extensionModel) {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        String configParameter = operationRefModel.getParameters().get(MODULE_OPERATION_CONFIG_REF);
        if (configParameter != null) {
            ComponentModel configRefComponentModel = this.applicationModel.getRootComponentModel().getInnerComponents().stream().filter(componentModel -> componentModel.getIdentifier().getNamespace().equals(extensionModel.getXmlDslModel().getPrefix()) && componentModel.getIdentifier().getName().equals("config") && configParameter.equals(componentModel.getParameters().get("name"))).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("There's no <%s:config> named [%s] in the current mule app", extensionModel.getXmlDslModel().getPrefix(), configParameter)));
            valuesMap.putAll(this.extractParameters(configRefComponentModel, extensionModel.getConfigurationModel("config").get().getAllParameterModels()));
        }
        return valuesMap;
    }

    private Map<String, String> extractParameters(ComponentModel componentModel, List<ParameterModel> parameters) {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        for (ParameterModel parameterExtension : parameters) {
            String paramName = parameterExtension.getName();
            String value = null;
            switch (parameterExtension.getRole()) {
                case BEHAVIOUR: {
                    if (!componentModel.getParameters().containsKey(paramName)) break;
                    value = componentModel.getParameters().get(paramName);
                    break;
                }
                case CONTENT: 
                case PRIMARY_CONTENT: {
                    Optional<ComponentModel> childComponentModel = componentModel.getInnerComponents().stream().filter(cm -> paramName.equals(cm.getIdentifier().getName())).findFirst();
                    if (!childComponentModel.isPresent()) break;
                    value = childComponentModel.get().getTextContent();
                }
            }
            if (value == null && parameterExtension.getDefaultValue() != null) {
                value = (String)parameterExtension.getDefaultValue();
            }
            if (value == null) continue;
            valuesMap.put(paramName, value);
        }
        return valuesMap;
    }

    private ComponentModel copyComponentModel(ComponentModel modelToCopy, String configRefName, Set<String> moduleGlobalElementsNames, Map<String, String> literalsParameters) {
        ComponentModel.Builder operationReplacementModel = new ComponentModel.Builder();
        operationReplacementModel.setIdentifier(modelToCopy.getIdentifier()).setTextContent(modelToCopy.getTextContent());
        for (Map.Entry<String, Object> entry : modelToCopy.getCustomAttributes().entrySet()) {
            operationReplacementModel.addCustomAttribute(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : modelToCopy.getParameters().entrySet()) {
            this.validateConfigRefAttribute(modelToCopy, configRefName, (String)entry.getValue());
            String value = this.calculateAttributeValue(configRefName, moduleGlobalElementsNames, (String)entry.getValue());
            String optimizedValue = literalsParameters.getOrDefault(value, value);
            operationReplacementModel.addParameter(entry.getKey(), optimizedValue, false);
        }
        for (ComponentModel componentModel : modelToCopy.getInnerComponents()) {
            operationReplacementModel.addChildComponentModel(this.copyComponentModel(componentModel, configRefName, moduleGlobalElementsNames, literalsParameters));
        }
        String configFileName = modelToCopy.getConfigFileName().orElseThrow(() -> new IllegalArgumentException("The is no config file name for the component to macro expand"));
        Integer n = modelToCopy.getLineNumber().orElseThrow(() -> new IllegalArgumentException("The is no line number for the component to macro expand"));
        operationReplacementModel.setConfigFileName(configFileName);
        operationReplacementModel.setLineNumber(n);
        ComponentModel componentModel = operationReplacementModel.build();
        for (ComponentModel child : componentModel.getInnerComponents()) {
            child.setParent(componentModel);
        }
        return componentModel;
    }

    private void validateConfigRefAttribute(ComponentModel modelToCopy, String configRefName, String originalValue) {
        if (MODULE_OPERATION_CONFIG_REF.equals(configRefName) && StringUtils.isBlank((CharSequence)originalValue)) {
            throw new IllegalArgumentException(String.format("The operation '%s' is missing the '%s' attribute", modelToCopy.getIdentifier().getName(), MODULE_OPERATION_CONFIG_REF));
        }
    }

    private String calculateAttributeValue(String configRefNameToAppend, Set<String> moduleGlobalElementsNames, String originalValue) {
        return moduleGlobalElementsNames.contains(originalValue) ? originalValue.concat("-").concat(configRefNameToAppend) : originalValue;
    }
}

