/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.dsl.processor;

import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.retry.RetryNotifier;
import org.mule.runtime.core.api.retry.async.AsynchronousRetryTemplate;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.retry.policy.SimpleRetryPolicyTemplate;
import org.mule.runtime.dsl.api.component.AbstractAnnotatedObjectFactory;

public class RetryPolicyTemplateObjectFactory
extends AbstractAnnotatedObjectFactory<RetryPolicyTemplate>
implements MuleContextAware {
    private boolean blocking;
    private Integer count = 2;
    private Integer frequency = 2000;
    private MuleContext muleContext;
    private RetryNotifier retryNotifier;

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public void setFrequency(Integer frequency) {
        this.frequency = frequency;
    }

    public void setRetryNotifier(RetryNotifier retryNotifier) {
        this.retryNotifier = retryNotifier;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public RetryPolicyTemplate doGetObject() throws Exception {
        SimpleRetryPolicyTemplate retryPolicyTemplate = new SimpleRetryPolicyTemplate(this.frequency.intValue(), this.count);
        retryPolicyTemplate.setMuleContext(this.muleContext);
        if (this.retryNotifier != null) {
            retryPolicyTemplate.setNotifier(this.retryNotifier);
        }
        if (!this.blocking) {
            return new AsynchronousRetryTemplate(retryPolicyTemplate);
        }
        return retryPolicyTemplate;
    }
}

