/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.factories;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.processor.AnnotatedProcessor;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class FlowRefFactoryBean
extends AbstractAnnotatedObject
implements FactoryBean<Processor>,
ApplicationContextAware,
MuleContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowRefFactoryBean.class);
    private String refName;
    private ApplicationContext applicationContext;
    private MuleContext muleContext;

    public void setName(String name) {
        this.refName = name;
    }

    public Processor getObject() throws Exception {
        if (this.refName.isEmpty()) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull("flow reference is empty"));
        }
        return new FlowRefMessageProcessor();
    }

    protected Processor getReferencedFlow(String name, FlowConstruct flowConstruct) throws MuleException {
        if (name == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull(name));
        }
        Processor referencedFlow = (Processor)this.applicationContext.getBean(name);
        if (referencedFlow == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull(name));
        }
        if (!(referencedFlow instanceof Flow)) {
            if (referencedFlow instanceof AnnotatedObject) {
                ((AnnotatedObject)((Object)referencedFlow)).setAnnotations(this.getAnnotations());
            }
            if (referencedFlow instanceof Initialisable) {
                this.prepareProcessor(referencedFlow, flowConstruct);
                if (referencedFlow instanceof MessageProcessorChain) {
                    for (Processor processor : ((MessageProcessorChain)referencedFlow).getMessageProcessors()) {
                        this.prepareProcessor(processor, flowConstruct);
                    }
                }
                LifecycleUtils.initialiseIfNeeded(referencedFlow);
            }
            LifecycleUtils.startIfNeeded(referencedFlow);
        }
        return referencedFlow;
    }

    private void prepareProcessor(Processor p, FlowConstruct flowConstruct) {
        if (p instanceof FlowConstructAware) {
            ((FlowConstructAware)((Object)p)).setFlowConstruct(flowConstruct);
        }
        if (p instanceof MuleContextAware) {
            ((MuleContextAware)((Object)p)).setMuleContext(this.muleContext);
        }
    }

    public boolean isSingleton() {
        return true;
    }

    public Class<?> getObjectType() {
        return Processor.class;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    private class FlowRefMessageProcessor
    implements AnnotatedProcessor,
    FlowConstructAware,
    Stoppable,
    Disposable {
        private FlowConstruct flowConstruct;
        private LoadingCache<String, Processor> cache;
        private boolean isExpression;

        public FlowRefMessageProcessor() {
            this.cache = CacheBuilder.newBuilder().maximumSize(20L).build((CacheLoader)new CacheLoader<String, Processor>(){

                public Processor load(String key) throws Exception {
                    return FlowRefFactoryBean.this.getReferencedFlow(key, FlowRefMessageProcessor.this.flowConstruct);
                }
            });
            this.isExpression = FlowRefFactoryBean.this.muleContext.getExpressionManager().isExpression(FlowRefFactoryBean.this.refName);
        }

        @Override
        public Event process(Event event) throws MuleException {
            return MessageProcessors.processToApply(event, this);
        }

        @Override
        public Publisher<Event> apply(Publisher<Event> publisher) {
            return Flux.from(publisher).flatMap(event -> {
                Processor referencedProcessor;
                try {
                    referencedProcessor = this.resolveReferencedProcessor((Event)event);
                }
                catch (MuleException e) {
                    return Flux.error((Throwable)e);
                }
                if (referencedProcessor instanceof Flow) {
                    return Flux.just((Object)event).flatMap(request -> Mono.from(MessageProcessors.processWithChildContext(request, referencedProcessor, Optional.ofNullable(FlowRefFactoryBean.this.getLocation()), ((Flow)referencedProcessor).getExceptionListener())));
                }
                return Flux.just((Object)event).transform((Function)referencedProcessor);
            });
        }

        protected Processor resolveReferencedProcessor(Event event) throws MuleException {
            String flowName = this.isExpression ? FlowRefFactoryBean.this.muleContext.getExpressionManager().parse(FlowRefFactoryBean.this.refName, event, this.getLocation()) : FlowRefFactoryBean.this.refName;
            try {
                return (Processor)this.cache.getUnchecked((Object)flowName);
            }
            catch (UncheckedExecutionException e) {
                if (e.getCause() instanceof MuleRuntimeException) {
                    throw (MuleRuntimeException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public Object getAnnotation(QName name) {
            return FlowRefFactoryBean.this.getAnnotation(name);
        }

        @Override
        public Map<QName, Object> getAnnotations() {
            return FlowRefFactoryBean.this.getAnnotations();
        }

        @Override
        public void setAnnotations(Map<QName, Object> annotations) {
            FlowRefFactoryBean.this.setAnnotations(annotations);
        }

        @Override
        public void setFlowConstruct(FlowConstruct flowConstruct) {
            this.flowConstruct = flowConstruct;
        }

        @Override
        public ComponentLocation getLocation() {
            return FlowRefFactoryBean.this.getLocation();
        }

        @Override
        public void stop() throws MuleException {
            for (Processor p : this.cache.asMap().values()) {
                if (p instanceof Flow) continue;
                LifecycleUtils.stopIfNeeded(p);
            }
        }

        @Override
        public void dispose() {
            for (Processor p : this.cache.asMap().values()) {
                if (p instanceof Flow) continue;
                LifecycleUtils.disposeIfNeeded(p, LOGGER);
            }
            this.cache.invalidateAll();
            this.cache.cleanUp();
        }
    }
}

