/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.internal;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.TreeTraverser;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.runtime.config.spring.SpringRegistry;
import org.mule.runtime.core.api.lifecycle.LifecycleObject;
import org.mule.runtime.core.internal.lifecycle.RegistryLifecycleCallback;
import org.mule.runtime.core.internal.lifecycle.RegistryLifecycleManager;

class SpringLifecycleCallback
extends RegistryLifecycleCallback<SpringRegistry> {
    public SpringLifecycleCallback(RegistryLifecycleManager registryLifecycleManager) {
        super(registryLifecycleManager);
    }

    @Override
    protected Collection<?> lookupObjectsForLifecycle(LifecycleObject lo) {
        DependencyNode node;
        Map objects = this.getSpringRegistry().lookupEntriesForLifecycle(lo.getType());
        DependencyNode root = new DependencyNode(null);
        for (Map.Entry entry : objects.entrySet()) {
            this.addDependency(root, entry.getKey(), entry.getValue());
        }
        FluentIterable orderedNodes = new TreeTraverser<DependencyNode>(){

            public Iterable children(DependencyNode node) {
                return node.getChilds();
            }
        }.postOrderTraversal((Object)root);
        LinkedList<Object> orderedObjects = new LinkedList<Object>();
        Iterator iterator = orderedNodes.iterator();
        while (iterator.hasNext() && (node = (DependencyNode)iterator.next()) != root) {
            orderedObjects.add(node.getValue());
        }
        return orderedObjects;
    }

    private SpringRegistry getSpringRegistry() {
        return (SpringRegistry)this.registryLifecycleManager.getLifecycleObject();
    }

    private void addDependency(DependencyNode parent, String key, Object object) {
        this.addDependency(parent, key, object, new HashSet<String>());
    }

    private void addDependency(DependencyNode parent, String key, Object object, Set<String> processedKeys) {
        DependencyNode node = new DependencyNode(object);
        parent.addChild(node);
        if (!processedKeys.contains(key)) {
            processedKeys.add(key);
            for (Map.Entry<String, Object> dependency : this.getSpringRegistry().getDependencies(key).entrySet()) {
                this.addDependency(node, dependency.getKey(), dependency.getValue(), processedKeys);
            }
        }
    }

    private class DependencyNode {
        private final Object value;
        private final List<DependencyNode> childs = new LinkedList<DependencyNode>();

        private DependencyNode(Object value) {
            this.value = value;
        }

        public DependencyNode addChild(DependencyNode child) {
            this.childs.add(child);
            return this;
        }

        public List<DependencyNode> getChilds() {
            return this.childs;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

