/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.internal;

import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.DataTypeParamsBuilder;
import org.mule.runtime.config.spring.OptionalObjectsController;
import org.mule.runtime.config.spring.SpringRegistry;
import org.mule.runtime.config.spring.factories.BootstrapObjectFactoryBean;
import org.mule.runtime.config.spring.factories.ConstantFactoryBean;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.config.bootstrap.BootstrapObjectFactory;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.registry.Registry;
import org.mule.runtime.core.api.registry.RegistryProvider;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.internal.config.bootstrap.AbstractRegistryBootstrap;
import org.mule.runtime.core.internal.config.bootstrap.ObjectBootstrapProperty;
import org.mule.runtime.core.internal.config.bootstrap.TransformerBootstrapProperty;
import org.mule.runtime.core.transformer.TransformerUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;

public class SpringRegistryBootstrap
extends AbstractRegistryBootstrap
implements Initialisable {
    private OptionalObjectsController optionalObjectsController;
    private BiConsumer<String, BeanDefinition> beanDefinitionRegister;

    public SpringRegistryBootstrap(ArtifactType artifactType, MuleContext muleContext, OptionalObjectsController optionalObjectsController, BiConsumer<String, BeanDefinition> beanDefinitionRegister) {
        super(artifactType, muleContext);
        this.optionalObjectsController = optionalObjectsController;
        this.beanDefinitionRegister = beanDefinitionRegister;
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        try {
            this.absorbAndDiscardOtherRegistries();
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    @Override
    protected void registerTransformers() throws MuleException {
    }

    @Override
    protected void doRegisterTransformer(TransformerBootstrapProperty bootstrapProperty, Class<?> returnClass, Class<? extends Transformer> transformerClass) throws Exception {
        String name;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(transformerClass);
        DataType returnType = null;
        if (returnClass != null) {
            DataTypeParamsBuilder dataTypeBuilder = DataType.builder().type(returnClass);
            if (StringUtils.isNotEmpty((CharSequence)bootstrapProperty.getMimeType())) {
                dataTypeBuilder = dataTypeBuilder.mediaType(bootstrapProperty.getMimeType());
            }
            builder.addPropertyValue("returnDataType", (Object)dataTypeBuilder.build());
        }
        if ((name = bootstrapProperty.getName()) == null) {
            name = "_" + TransformerUtils.generateTransformerName(transformerClass, returnType);
        }
        builder.addPropertyValue("name", (Object)name);
        this.notifyIfOptional(name, bootstrapProperty.getOptional());
        this.doRegisterObject(name, builder);
    }

    private void absorbAndDiscardOtherRegistries() {
        if (!(this.muleContext.getRegistry() instanceof RegistryProvider)) {
            return;
        }
        for (Registry registry : ((RegistryProvider)((Object)this.muleContext.getRegistry())).getRegistries()) {
            if (registry instanceof SpringRegistry) continue;
            for (Map.Entry<String, Object> entry : registry.lookupByType(Object.class).entrySet()) {
                this.registerInstance(entry.getKey(), entry.getValue());
            }
            this.muleContext.removeRegistry(registry);
        }
    }

    @Override
    protected void doRegisterObject(ObjectBootstrapProperty bootstrapProperty) throws Exception {
        BeanDefinitionBuilder builder;
        this.notifyIfOptional(bootstrapProperty.getKey(), bootstrapProperty.getOptional());
        Class clazz = bootstrapProperty.getService().forName(bootstrapProperty.getClassName());
        if (BootstrapObjectFactory.class.isAssignableFrom(clazz)) {
            Object value = bootstrapProperty.getService().instantiateClass(bootstrapProperty.getClassName(), new Object[0]);
            LifecycleUtils.setMuleContextIfNeeded(value, this.muleContext);
            builder = BeanDefinitionBuilder.rootBeanDefinition(BootstrapObjectFactoryBean.class);
            builder.addConstructorArgValue(value);
        } else {
            builder = BeanDefinitionBuilder.rootBeanDefinition((Class)clazz);
        }
        this.doRegisterObject(bootstrapProperty.getKey(), builder);
    }

    private void notifyIfOptional(String key, boolean optional) {
        if (optional && this.optionalObjectsController != null) {
            this.optionalObjectsController.registerOptionalKey(key);
        }
    }

    private void doRegisterObject(String key, BeanDefinitionBuilder builder) {
        this.beanDefinitionRegister.accept(key, (BeanDefinition)builder.getBeanDefinition());
    }

    private void registerInstance(String key, Object value) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ConstantFactoryBean.class);
        builder.addConstructorArgValue(value);
        this.doRegisterObject(key, builder);
    }
}

