/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.internal.util.rx.Operators;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

abstract class AbstractEventContext
implements EventContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEventContext.class);
    private transient MonoProcessor<Event> beforeResponseProcessor;
    private transient MonoProcessor<Event> responseProcessor;
    private transient MonoProcessor<Void> completionProcessor;
    private transient Disposable completionSubscriberDisposable;
    private final transient List<EventContext> childContexts = new LinkedList<EventContext>();
    private transient Mono<Void> completionCallback = Mono.empty();
    private transient MessagingExceptionHandler exceptionHandler;

    public AbstractEventContext() {
        this(ExceptionUtils.NULL_ERROR_HANDLER, (Publisher<Void>)Mono.empty());
    }

    public AbstractEventContext(MessagingExceptionHandler exceptionHandler) {
        this(exceptionHandler, (Publisher<Void>)Mono.empty());
    }

    public AbstractEventContext(MessagingExceptionHandler exceptionHandler, Publisher<Void> completionCallback) {
        this.completionCallback = Mono.from(completionCallback);
        this.exceptionHandler = exceptionHandler;
        this.initCompletionProcessor();
    }

    private void initCompletionProcessor() {
        this.beforeResponseProcessor = MonoProcessor.create();
        this.responseProcessor = MonoProcessor.create();
        this.responseProcessor.doOnEach(s -> s.accept(this.beforeResponseProcessor)).subscribe(Operators.requestUnbounded());
        this.completionProcessor = MonoProcessor.create();
        this.completionProcessor.doFinally(e -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this + " execution completed.");
            }
        }).subscribe();
        this.completionSubscriberDisposable = Mono.whenDelayError((Publisher[])new Publisher[]{this.completionCallback, this.responseProcessor.materialize().then()}).doOnEach(s -> s.accept(this.completionProcessor)).subscribe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChildContext(EventContext childContext) {
        AbstractEventContext abstractEventContext = this;
        synchronized (abstractEventContext) {
            this.childContexts.add(childContext);
            this.updateCompletionPublisher();
        }
    }

    private void updateCompletionPublisher() {
        this.completionSubscriberDisposable.dispose();
        this.completionSubscriberDisposable = this.responseProcessor.onErrorResume(throwable -> Mono.empty()).and(this.completionCallback).and(this.getChildCompletionPublisher()).materialize().then().doOnEach(s -> s.accept(this.completionProcessor)).subscribe();
    }

    private Mono<Void> getChildCompletionPublisher() {
        return Mono.when((Iterable)this.childContexts.stream().map(eventContext -> Mono.from(eventContext.getCompletionPublisher())).collect(Collectors.toList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void success() {
        AbstractEventContext abstractEventContext = this;
        synchronized (abstractEventContext) {
            if (this.responseProcessor.isTerminated()) {
                LOGGER.info(this + " empty response was already completed, ignoring.");
                return;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this + " response completed with no result.");
            }
            this.responseProcessor.onComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void success(Event event) {
        AbstractEventContext abstractEventContext = this;
        synchronized (abstractEventContext) {
            if (this.responseProcessor.isTerminated()) {
                LOGGER.info(this + " response was already completed, ignoring.");
                return;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this + " response completed with result.");
            }
            this.responseProcessor.onNext((Object)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Publisher<Void> error(Throwable throwable) {
        AbstractEventContext abstractEventContext = this;
        synchronized (abstractEventContext) {
            if (this.responseProcessor.isTerminated()) {
                LOGGER.info(this + " error response was already completed, ignoring.");
                return Mono.empty();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this + " response completed with error.");
            }
            if (throwable instanceof MessagingException) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(this + " handling messaging exception.");
                }
                return Mono.just((Object)((MessagingException)throwable)).flatMapMany((Function)this.exceptionHandler).doOnNext(handled -> this.success((Event)handled)).doOnError(rethrown -> this.responseProcessor.onError(rethrown)).materialize().then().subscribe();
            }
            this.responseProcessor.onError(throwable);
            return Mono.empty();
        }
    }

    @Override
    public Publisher<Event> getBeforeResponsePublisher() {
        return this.beforeResponseProcessor;
    }

    @Override
    public Publisher<Event> getResponsePublisher() {
        return this.responseProcessor;
    }

    @Override
    public Publisher<Void> getCompletionPublisher() {
        return this.completionProcessor;
    }

    protected MessagingExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }
}

