/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.context;

import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.core.DefaultMuleContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.config.bootstrap.BootstrapServiceDiscoverer;
import org.mule.runtime.core.api.config.bootstrap.PropertiesBootstrapServiceDiscoverer;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.context.MuleContextBuilder;
import org.mule.runtime.core.api.context.notification.AsyncMessageNotification;
import org.mule.runtime.core.api.context.notification.AsyncMessageNotificationListener;
import org.mule.runtime.core.api.context.notification.ClusterNodeNotification;
import org.mule.runtime.core.api.context.notification.ClusterNodeNotificationListener;
import org.mule.runtime.core.api.context.notification.ConnectionNotification;
import org.mule.runtime.core.api.context.notification.ConnectionNotificationListener;
import org.mule.runtime.core.api.context.notification.CustomNotification;
import org.mule.runtime.core.api.context.notification.CustomNotificationListener;
import org.mule.runtime.core.api.context.notification.ErrorHandlerNotification;
import org.mule.runtime.core.api.context.notification.ErrorHandlerNotificationListener;
import org.mule.runtime.core.api.context.notification.ExceptionNotification;
import org.mule.runtime.core.api.context.notification.ExceptionNotificationListener;
import org.mule.runtime.core.api.context.notification.ManagementNotification;
import org.mule.runtime.core.api.context.notification.ManagementNotificationListener;
import org.mule.runtime.core.api.context.notification.MuleContextNotification;
import org.mule.runtime.core.api.context.notification.MuleContextNotificationListener;
import org.mule.runtime.core.api.context.notification.PipelineMessageNotification;
import org.mule.runtime.core.api.context.notification.PipelineMessageNotificationListener;
import org.mule.runtime.core.api.context.notification.RegistryNotification;
import org.mule.runtime.core.api.context.notification.RegistryNotificationListener;
import org.mule.runtime.core.api.context.notification.RoutingNotification;
import org.mule.runtime.core.api.context.notification.RoutingNotificationListener;
import org.mule.runtime.core.api.context.notification.SecurityNotification;
import org.mule.runtime.core.api.context.notification.SecurityNotificationListener;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;
import org.mule.runtime.core.api.context.notification.TransactionNotification;
import org.mule.runtime.core.api.context.notification.TransactionNotificationListener;
import org.mule.runtime.core.api.exception.ErrorTypeRepository;
import org.mule.runtime.core.api.exception.SystemExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleManager;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.client.DefaultLocalMuleClient;
import org.mule.runtime.core.internal.exception.DefaultSystemExceptionStrategy;
import org.mule.runtime.core.internal.exception.ErrorTypeLocatorFactory;
import org.mule.runtime.core.internal.exception.ErrorTypeRepositoryFactory;
import org.mule.runtime.core.internal.lifecycle.MuleContextLifecycleManager;
import org.mule.runtime.core.internal.processor.interceptor.DefaultProcessorInterceptorManager;
import org.mule.runtime.core.internal.serialization.JavaObjectSerializer;
import org.mule.runtime.core.registry.DefaultRegistryBroker;
import org.mule.runtime.core.registry.MuleRegistryHelper;
import org.mule.runtime.core.registry.RegistryDelegatingInjector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMuleContextBuilder
implements MuleContextBuilder {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultMuleContextBuilder.class);
    protected MuleConfiguration config;
    private MuleContextLifecycleManager lifecycleManager;
    protected ServerNotificationManager notificationManager;
    protected BootstrapServiceDiscoverer bootstrapDiscoverer;
    protected ClassLoader executionClassLoader;
    protected ObjectSerializer objectSerializer;

    @Override
    public MuleContext buildMuleContext() {
        logger.debug("Building new DefaultMuleContext instance with MuleContextBuilder: " + this);
        DefaultMuleContext muleContext = this.createDefaultMuleContext();
        muleContext.setMuleConfiguration(this.injectMuleContextIfRequired(this.getMuleConfiguration(), muleContext));
        muleContext.setNotificationManager(this.injectMuleContextIfRequired(this.getNotificationManager(), muleContext));
        muleContext.setLifecycleManager(this.injectMuleContextIfRequired(this.getLifecycleManager(), muleContext));
        DefaultRegistryBroker registryBroker = new DefaultRegistryBroker(muleContext);
        muleContext.setRegistryBroker(registryBroker);
        MuleRegistryHelper muleRegistry = new MuleRegistryHelper(registryBroker, muleContext);
        muleContext.setMuleRegistry(muleRegistry);
        muleContext.setInjector(new RegistryDelegatingInjector(muleRegistry));
        muleContext.setLocalMuleClient(new DefaultLocalMuleClient(muleContext));
        muleContext.setExceptionListener(this.createExceptionListener(muleContext));
        muleContext.setExecutionClassLoader(this.getExecutionClassLoader());
        muleContext.setBootstrapServiceDiscoverer(this.injectMuleContextIfRequired(this.getBootstrapPropertiesServiceDiscoverer(), muleContext));
        this.getObjectSerializer(muleContext);
        ErrorTypeRepository defaultErrorTypeRepository = ErrorTypeRepositoryFactory.createDefaultErrorTypeRepository();
        muleContext.setErrorTypeRepository(defaultErrorTypeRepository);
        muleContext.setErrorTypeLocator(ErrorTypeLocatorFactory.createDefaultErrorTypeLocator(defaultErrorTypeRepository));
        muleContext.setProcessorInterceptorManager(new DefaultProcessorInterceptorManager());
        return muleContext;
    }

    private void getObjectSerializer(DefaultMuleContext muleContext) {
        if (this.objectSerializer == null) {
            this.objectSerializer = new JavaObjectSerializer();
        }
        if (this.objectSerializer instanceof MuleContextAware) {
            ((MuleContextAware)((Object)this.objectSerializer)).setMuleContext(muleContext);
        }
        muleContext.setObjectSerializer(this.objectSerializer);
    }

    protected SystemExceptionHandler createExceptionListener(DefaultMuleContext muleContext) {
        SystemExceptionHandler systemExceptionHandler = (SystemExceptionHandler)muleContext.getRegistry().get("_exceptionListenerFactory");
        if (systemExceptionHandler == null) {
            systemExceptionHandler = new DefaultSystemExceptionStrategy();
        }
        return systemExceptionHandler;
    }

    protected DefaultMuleContext createDefaultMuleContext() {
        return new DefaultMuleContext();
    }

    @Override
    public void setMuleConfiguration(MuleConfiguration config) {
        this.config = config;
    }

    @Override
    public void setNotificationManager(ServerNotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    protected MuleConfiguration getMuleConfiguration() {
        if (this.config != null) {
            return this.config;
        }
        return this.createMuleConfiguration();
    }

    @Override
    public void setExecutionClassLoader(ClassLoader executionClassLoader) {
        this.executionClassLoader = executionClassLoader;
    }

    @Override
    public void setObjectSerializer(ObjectSerializer objectSerializer) {
        this.objectSerializer = objectSerializer;
    }

    protected ClassLoader getExecutionClassLoader() {
        if (this.executionClassLoader != null) {
            return this.executionClassLoader;
        }
        return Thread.currentThread().getContextClassLoader();
    }

    public <T> T injectMuleContextIfRequired(T object, MuleContext muleContext) {
        if (object instanceof MuleContextAware) {
            ((MuleContextAware)object).setMuleContext(muleContext);
        }
        return object;
    }

    protected LifecycleManager getLifecycleManager() {
        if (this.lifecycleManager != null) {
            return this.lifecycleManager;
        }
        return this.createLifecycleManager();
    }

    @Override
    public void setLifecycleManager(LifecycleManager manager) {
        if (!(manager instanceof MuleContextLifecycleManager)) {
            I18nMessage msg = I18nMessageFactory.createStaticMessage("lifecycle manager for MuleContext must be a MuleContextLifecycleManager");
            throw new MuleRuntimeException(msg);
        }
        this.lifecycleManager = (MuleContextLifecycleManager)manager;
    }

    protected ServerNotificationManager getNotificationManager() {
        if (this.notificationManager != null) {
            return this.notificationManager;
        }
        return this.createNotificationManager();
    }

    public void setBootstrapPropertiesServiceDiscoverer(BootstrapServiceDiscoverer bootstrapDiscoverer) {
        this.bootstrapDiscoverer = bootstrapDiscoverer;
    }

    public BootstrapServiceDiscoverer getBootstrapPropertiesServiceDiscoverer() {
        if (this.bootstrapDiscoverer != null) {
            return this.bootstrapDiscoverer;
        }
        return this.createBootstrapDiscoverer();
    }

    protected BootstrapServiceDiscoverer createBootstrapDiscoverer() {
        return new PropertiesBootstrapServiceDiscoverer(DefaultMuleContextBuilder.class.getClassLoader());
    }

    protected DefaultMuleConfiguration createMuleConfiguration() {
        return new DefaultMuleConfiguration();
    }

    private MuleContextLifecycleManager createLifecycleManager() {
        return new MuleContextLifecycleManager();
    }

    protected ServerNotificationManager createNotificationManager() {
        return DefaultMuleContextBuilder.createDefaultNotificationManager();
    }

    public static ServerNotificationManager createDefaultNotificationManager() {
        ServerNotificationManager manager = new ServerNotificationManager();
        manager.addInterfaceToType(MuleContextNotificationListener.class, MuleContextNotification.class);
        manager.addInterfaceToType(RoutingNotificationListener.class, RoutingNotification.class);
        manager.addInterfaceToType(SecurityNotificationListener.class, SecurityNotification.class);
        manager.addInterfaceToType(ManagementNotificationListener.class, ManagementNotification.class);
        manager.addInterfaceToType(CustomNotificationListener.class, CustomNotification.class);
        manager.addInterfaceToType(ConnectionNotificationListener.class, ConnectionNotification.class);
        manager.addInterfaceToType(RegistryNotificationListener.class, RegistryNotification.class);
        manager.addInterfaceToType(ExceptionNotificationListener.class, ExceptionNotification.class);
        manager.addInterfaceToType(ErrorHandlerNotificationListener.class, ErrorHandlerNotification.class);
        manager.addInterfaceToType(TransactionNotificationListener.class, TransactionNotification.class);
        manager.addInterfaceToType(PipelineMessageNotificationListener.class, PipelineMessageNotification.class);
        manager.addInterfaceToType(AsyncMessageNotificationListener.class, AsyncMessageNotification.class);
        manager.addInterfaceToType(ClusterNodeNotificationListener.class, ClusterNodeNotification.class);
        return manager;
    }

    public String toString() {
        return ClassUtils.getClassName(this.getClass()) + "{muleConfiguration=" + this.config + ", lifecycleManager=" + this.lifecycleManager + ", notificationManager=" + this.notificationManager + "}";
    }
}

