/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.context.notification;

import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.context.notification.EnrichedNotificationInfo;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.context.notification.ServerNotification;
import org.mule.runtime.core.api.message.GroupCorrelation;

public abstract class EnrichedServerNotification
extends ServerNotification {
    protected EnrichedNotificationInfo notificationInfo;

    public EnrichedServerNotification(EnrichedNotificationInfo notificationInfo, int action, String resourceIdentifier) {
        super(notificationInfo, action, resourceIdentifier);
        this.notificationInfo = notificationInfo;
    }

    public EnrichedServerNotification(EnrichedNotificationInfo notificationInfo, int action, ComponentLocation componentLocation) {
        this(notificationInfo, action, componentLocation != null ? componentLocation.getRootContainerName() : null);
    }

    @Override
    @Deprecated
    public Object getSource() {
        return this.notificationInfo;
    }

    public String getUniqueId() {
        return this.notificationInfo.getUniqueId();
    }

    public String getCorrelationId() {
        return this.notificationInfo.getCorrelationId();
    }

    public GroupCorrelation getGroupCorrelation() {
        return this.notificationInfo.getGroupCorrelation();
    }

    public Message getMessage() {
        return this.notificationInfo.getMessage();
    }

    public Optional<Error> getError() {
        return this.notificationInfo.getError();
    }

    public AnnotatedObject getComponent() {
        return this.notificationInfo.getComponent();
    }

    public FlowCallStack getFlowCallStack() {
        return this.notificationInfo.getFlowCallStack();
    }

    public Exception getException() {
        return this.notificationInfo.getException();
    }

    public Map<String, TypedValue> getVariables() {
        return this.notificationInfo.getVariables();
    }

    public String getOriginatingFlowName() {
        return this.notificationInfo.getOriginatingFlowName();
    }

    @Override
    public String toString() {
        return this.EVENT_NAME + "{action=" + EnrichedServerNotification.getActionName(this.action) + ", resourceId=" + this.resourceIdentifier + ", serverId=" + this.serverId + ", timestamp=" + this.timestamp + "}";
    }

    public String getLocationUri() {
        if (this.getComponent() == null) {
            return null;
        }
        ComponentLocation location = this.getComponent().getLocation();
        return location.getRootContainerName() + "/" + location.getComponentIdentifier().getIdentifier().toString();
    }

    public EnrichedNotificationInfo getInfo() {
        return this.notificationInfo;
    }
}

