/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.context.notification;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.context.notification.ListenerSubscriptionPair;
import org.mule.runtime.core.api.context.notification.NotifierCallback;
import org.mule.runtime.core.api.context.notification.ServerNotification;
import org.mule.runtime.core.api.context.notification.ServerNotificationHandler;
import org.mule.runtime.core.api.context.notification.ServerNotificationListener;
import org.mule.runtime.core.api.context.notification.SynchronousServerEvent;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.context.notification.Configuration;
import org.mule.runtime.core.internal.context.notification.Policy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerNotificationManager
implements ServerNotificationHandler,
MuleContextAware {
    private static final Logger logger = LoggerFactory.getLogger(ServerNotificationManager.class);
    private boolean dynamic = false;
    private Configuration configuration = new Configuration();
    private ReentrantReadWriteLock disposeLock = new ReentrantReadWriteLock();
    private AtomicBoolean disposed = new AtomicBoolean(false);
    private MuleContext muleContext;
    private Scheduler notificationsLiteScheduler;
    private Scheduler notificationsIoScheduler;

    @Override
    public boolean isNotificationDynamic() {
        return this.dynamic;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void setNotificationDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public void initialise() throws InitialisationException {
        this.notificationsLiteScheduler = this.muleContext.getSchedulerService().cpuLightScheduler();
        this.notificationsIoScheduler = this.muleContext.getSchedulerService().ioScheduler();
    }

    public void addInterfaceToType(Class<? extends ServerNotificationListener> iface, Class<? extends ServerNotification> event) {
        this.configuration.addInterfaceToType(iface, event);
    }

    public void setInterfaceToTypes(Map<Class<? extends ServerNotificationListener>, Set<Class<? extends ServerNotification>>> interfaceToEvents) throws ClassNotFoundException {
        this.configuration.addAllInterfaceToTypes(interfaceToEvents);
    }

    public void addListenerSubscriptionPair(ListenerSubscriptionPair pair) {
        this.configuration.addListenerSubscriptionPair(pair);
    }

    public void addListener(ServerNotificationListener<?> listener) {
        this.configuration.addListenerSubscriptionPair(new ListenerSubscriptionPair(listener));
    }

    public void addListenerSubscription(ServerNotificationListener<?> listener, String subscription) {
        this.configuration.addListenerSubscriptionPair(new ListenerSubscriptionPair(listener, subscription));
    }

    public void removeListener(ServerNotificationListener<?> listener) {
        this.configuration.removeListener(listener);
    }

    public void disableInterface(Class<? extends ServerNotificationListener> iface) {
        this.configuration.disableInterface(iface);
    }

    public void setDisabledInterfaces(Collection<Class<? extends ServerNotificationListener>> interfaces) throws ClassNotFoundException {
        this.configuration.disabledAllInterfaces(interfaces);
    }

    public void disableType(Class<? extends ServerNotification> type) {
        this.configuration.disableType(type);
    }

    @Override
    public boolean isListenerRegistered(ServerNotificationListener listener) {
        for (ListenerSubscriptionPair pair : this.configuration.getListeners()) {
            if (!pair.getListener().equals(listener)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void fireNotification(ServerNotification notification) {
        this.disposeLock.readLock().lock();
        try {
            if (this.disposed.get()) {
                logger.warn("Notification not enqueued after ServerNotificationManager disposal: " + notification);
                return;
            }
            notification.setMuleContext(this.muleContext);
            if (notification instanceof SynchronousServerEvent) {
                this.notifyListeners(notification, (listener, nfn) -> listener.onNotification(nfn));
            } else {
                this.notifyListeners(notification, (listener, nfn) -> {
                    if (listener.isBlocking()) {
                        this.notificationsIoScheduler.submit(() -> listener.onNotification(nfn));
                    } else {
                        this.notificationsLiteScheduler.submit(() -> listener.onNotification(nfn));
                    }
                });
            }
        }
        finally {
            this.disposeLock.readLock().unlock();
        }
    }

    protected void notifyListeners(ServerNotification notification, NotifierCallback notifier) {
        this.configuration.getPolicy().dispatch(notification, notifier);
    }

    @Override
    public boolean isNotificationEnabled(Class<? extends ServerNotification> type) {
        Policy policy;
        boolean enabled = false;
        if (this.configuration != null && (policy = this.configuration.getPolicy()) != null) {
            enabled = policy.isNotificationEnabled(type);
        }
        return enabled;
    }

    public void dispose() {
        this.disposeLock.writeLock().lock();
        try {
            if (this.notificationsLiteScheduler != null) {
                this.notificationsLiteScheduler.stop();
                this.notificationsLiteScheduler = null;
            }
            if (this.notificationsIoScheduler != null) {
                this.notificationsIoScheduler.stop();
                this.notificationsIoScheduler = null;
            }
            this.disposed.set(true);
            this.configuration = null;
        }
        finally {
            this.disposeLock.writeLock().unlock();
        }
    }

    public static Class toClass(Object value) throws ClassNotFoundException {
        Class clazz;
        if (value instanceof String) {
            clazz = ClassUtils.loadClass(value.toString(), value.getClass());
        } else if (value instanceof Class) {
            clazz = (Class)value;
        } else {
            throw new IllegalArgumentException("Notification types and listeners must be a Class with fully qualified class name. Value is: " + value);
        }
        return clazz;
    }

    Policy getPolicy() {
        return this.configuration.getPolicy();
    }

    public Map<Class<? extends ServerNotificationListener>, Set<Class<? extends ServerNotification>>> getInterfaceToTypes() {
        return Collections.unmodifiableMap(this.configuration.getInterfaceToTypes());
    }

    public Set<ListenerSubscriptionPair> getListeners() {
        return Collections.unmodifiableSet(this.configuration.getListeners());
    }

    public boolean isDisposed() {
        return this.disposed.get();
    }
}

