/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.exception;

import java.util.function.Function;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.exception.ExceptionHandler;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.rx.Exceptions;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface MessagingExceptionHandler
extends ExceptionHandler,
Function<MessagingException, Publisher<Event>> {
    public Event handleException(MessagingException var1, Event var2);

    @Override
    default public Publisher<Event> apply(MessagingException exception) {
        try {
            exception.setProcessedEvent(this.handleException(exception, exception.getEvent()));
            if (exception.handled()) {
                return Mono.just((Object)exception.getEvent());
            }
            return Flux.error((Throwable)exception);
        }
        catch (Throwable throwable) {
            return Flux.error((Throwable)Exceptions.propagateWrappingFatal(throwable));
        }
    }
}

