/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.policy;

import java.util.Optional;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleState;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.api.policy.PolicyChain;
import org.mule.runtime.core.api.policy.PolicyInstance;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.core.internal.lifecycle.DefaultLifecycleManager;
import org.mule.runtime.core.internal.management.stats.DefaultFlowConstructStatistics;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class DefaultPolicyInstance
implements PolicyInstance,
FlowConstruct,
MuleContextAware,
Lifecycle {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPolicyInstance.class);
    private PolicyChain operationPolicyChain;
    private PolicyChain sourcePolicyChain;
    private FlowConstructStatistics flowConstructStatistics = new DefaultFlowConstructStatistics("policy", this.getName());
    private String name = "proxy-policy-" + UUID.getUUID();
    private MuleContext muleContext;
    private DefaultLifecycleManager lifecycleStateManager = new DefaultLifecycleManager<DefaultPolicyInstance>(this.name, this);

    @Override
    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Object)this.operationPolicyChain, this.muleContext, this);
        LifecycleUtils.initialiseIfNeeded((Object)this.sourcePolicyChain, this.muleContext, this);
        this.lifecycleStateManager.fireInitialisePhase((phaseNam, object) -> {});
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.operationPolicyChain);
        LifecycleUtils.startIfNeeded(this.sourcePolicyChain);
        this.lifecycleStateManager.fireStartPhase((phaseNam, object) -> {});
    }

    @Override
    public MessagingExceptionHandler getExceptionListener() {
        return new MessagingExceptionHandler(){

            @Override
            public Event handleException(MessagingException exception, Event event) {
                return null;
            }

            @Override
            public Publisher<Event> apply(MessagingException exception) {
                return Mono.error((Throwable)exception);
            }
        };
    }

    @Override
    public FlowConstructStatistics getStatistics() {
        return this.flowConstructStatistics;
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    @Override
    public String getUniqueIdString() {
        return this.muleContext.getUniqueIdString();
    }

    @Override
    public String getServerId() {
        return this.muleContext.getId();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public LifecycleState getLifecycleState() {
        return this.lifecycleStateManager.getState();
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.operationPolicyChain, logger);
        LifecycleUtils.disposeIfNeeded(this.sourcePolicyChain, logger);
        this.lifecycleStateManager.fireDisposePhase((phaseNam, object) -> {});
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.operationPolicyChain);
        LifecycleUtils.stopIfNeeded(this.sourcePolicyChain);
        this.lifecycleStateManager.fireStopPhase((phaseNam, object) -> {});
    }

    public void setOperationPolicyChain(PolicyChain request) {
        this.operationPolicyChain = request;
    }

    public void setSourcePolicyChain(PolicyChain source) {
        this.sourcePolicyChain = source;
    }

    @Override
    public Optional<PolicyChain> getSourcePolicyChain() {
        return Optional.ofNullable(this.sourcePolicyChain);
    }

    @Override
    public Optional<PolicyChain> getOperationPolicyChain() {
        return Optional.ofNullable(this.operationPolicyChain);
    }
}

