/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.policy;

import java.util.function.Function;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.policy.PolicyStateHandler;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class PolicyNextActionMessageProcessor
extends AbstractAnnotatedObject
implements Processor {
    @Inject
    private PolicyStateHandler policyStateHandler;

    @Override
    public Event process(Event event) throws MuleException {
        return MessageProcessors.processToApply(event, this);
    }

    @Override
    public Publisher<Event> apply(Publisher<Event> publisher) {
        return Mono.from(publisher).flatMapMany(event -> {
            Processor nextOperation = this.policyStateHandler.retrieveNextOperation(event.getContext().getCorrelationId());
            if (nextOperation == null) {
                return Mono.error((Throwable)new MuleRuntimeException(I18nMessageFactory.createStaticMessage("There's no next operation configured for event context id " + event.getContext().getId())));
            }
            return Mono.just((Object)event).transform((Function)nextOperation);
        });
    }
}

