/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.processor;

import java.util.List;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMuleObjectOwner<T>
extends AbstractAnnotatedObject
implements Lifecycle,
MuleContextAware,
FlowConstructAware {
    @Inject
    protected MuleContext muleContext;
    protected FlowConstruct flowConstruct;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
        LifecycleUtils.setMuleContextIfNeeded(this.getOwnedObjects(), muleContext);
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
        LifecycleUtils.setFlowConstructIfNeeded(this.getOwnedObjects(), flowConstruct);
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    @Override
    public void initialise() throws InitialisationException {
        this.setMuleContext(this.muleContext);
        this.setFlowConstruct(this.flowConstruct);
        LifecycleUtils.initialiseIfNeeded(this.getOwnedObjects(), true, this.muleContext);
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.getOwnedObjects(), this.logger);
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.getOwnedObjects());
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.getOwnedObjects());
    }

    protected abstract List<T> getOwnedObjects();
}

