/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.processor.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class InvokerMessageProcessorUtil {
    private InvokerMessageProcessorUtil() {
    }

    public static List<String> splitArgumentsExpression(String arguments) {
        String[] argumentsSplitted = arguments.split("\\s*,\\s*");
        if (argumentsSplitted.length <= 1) {
            return Arrays.asList(argumentsSplitted);
        }
        return InvokerMessageProcessorUtil.merge(argumentsSplitted);
    }

    private static List<String> merge(String[] argumentsSplitted) {
        ArrayList<String> argumentsVerified = new ArrayList<String>();
        StringBuffer mergingArg = new StringBuffer();
        mergingArg.append(argumentsSplitted[0]);
        for (int index = 1; index < argumentsSplitted.length; ++index) {
            String arg = argumentsSplitted[index];
            if (InvokerMessageProcessorUtil.hasToBeMerged(mergingArg)) {
                mergingArg.append("," + arg);
                continue;
            }
            argumentsVerified.add(mergingArg.toString().trim());
            mergingArg = new StringBuffer(arg);
        }
        argumentsVerified.add(mergingArg.toString().trim());
        return argumentsVerified;
    }

    private static boolean hasToBeMerged(StringBuffer mergingArg) {
        return StringUtils.countMatches((CharSequence)mergingArg.toString(), (CharSequence)"[") != StringUtils.countMatches((CharSequence)mergingArg.toString(), (CharSequence)"]");
    }
}

