/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.retry.policy;

import java.io.InterruptedIOException;
import java.util.Map;
import java.util.concurrent.Executor;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.retry.RetryCallback;
import org.mule.runtime.core.api.retry.RetryContext;
import org.mule.runtime.core.api.retry.RetryNotifier;
import org.mule.runtime.core.api.retry.policy.ConnectNotifier;
import org.mule.runtime.core.api.retry.policy.PolicyStatus;
import org.mule.runtime.core.api.retry.policy.RetryPolicy;
import org.mule.runtime.core.api.retry.policy.RetryPolicyExhaustedException;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.internal.retry.DefaultRetryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPolicyTemplate
implements RetryPolicyTemplate,
MuleContextAware {
    protected RetryNotifier notifier = new ConnectNotifier();
    private Map<Object, Object> metaInfo;
    private MuleContext muleContext;
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public RetryContext execute(RetryCallback callback, Executor workManager) throws Exception {
        PolicyStatus status = null;
        RetryPolicy policy = this.createRetryInstance();
        DefaultRetryContext context = new DefaultRetryContext(callback.getWorkDescription(), this.metaInfo);
        context.setMuleContext(this.muleContext);
        try {
            Exception cause = null;
            while (true) {
                try {
                    callback.doWork(context);
                    if (this.notifier == null) break;
                    this.notifier.onSuccess(context);
                }
                catch (Exception e) {
                    cause = e;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Error executing policy", (Throwable)cause);
                    }
                    if (this.notifier != null) {
                        this.notifier.onFailure(context, cause);
                    }
                    if (!(cause instanceof InterruptedException) && !(cause instanceof InterruptedIOException)) continue;
                    this.logger.error("Process was interrupted (InterruptedException), ceasing process");
                    break;
                    if ((status = policy.applyPolicy(cause)).isOk()) continue;
                }
                break;
            }
            if (status == null || status.isOk()) {
                DefaultRetryContext defaultRetryContext = context;
                return defaultRetryContext;
            }
            context.setFailed(cause);
            throw new RetryPolicyExhaustedException(cause, callback.getWorkOwner());
        }
        finally {
            if (status != null && status.getThrowable() != null && this.logger.isDebugEnabled()) {
                this.logger.debug("Error executing policy", status.getThrowable());
            }
        }
    }

    @Override
    public RetryNotifier getNotifier() {
        return this.notifier;
    }

    @Override
    public void setNotifier(RetryNotifier retryNotifier) {
        this.notifier = retryNotifier;
    }

    @Override
    public Map<Object, Object> getMetaInfo() {
        return this.metaInfo;
    }

    @Override
    public void setMetaInfo(Map<Object, Object> metaInfo) {
        this.metaInfo = metaInfo;
    }

    public void setId(String id) {
    }
}

