/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.store;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.store.AbstractPartitionedObjectStore;
import org.mule.runtime.core.api.store.PartitionableExpirableObjectStore;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.core.internal.util.store.PersistentObjectStorePartition;

public class PartitionedPersistentObjectStore<T extends Serializable>
extends AbstractPartitionedObjectStore<T>
implements MuleContextAware,
PartitionableExpirableObjectStore<T> {
    public static final String OBJECT_STORE_DIR = "objectstore";
    private MuleContext muleContext;
    private File storeDirectory;
    private Map<String, PersistentObjectStorePartition> partitionsByName = new HashMap<String, PersistentObjectStorePartition>();
    private boolean initialized = false;

    public PartitionedPersistentObjectStore() {
    }

    public PartitionedPersistentObjectStore(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public synchronized void open() throws ObjectStoreException {
        if (!this.initialized) {
            this.initObjectStoreDirectory();
            this.loadPreviousStoredPartitions();
            this.createDefaultPartition();
            this.initialized = true;
        }
    }

    private void createDefaultPartition() throws ObjectStoreException {
        if (!this.partitionsByName.containsKey("DEFAULT_PARTITION")) {
            this.createPartition("DEFAULT_PARTITION");
        }
    }

    @Override
    public synchronized void open(String partitionName) throws ObjectStoreException {
        this.open();
        if (!this.partitionsByName.containsKey(partitionName)) {
            this.createPartition(partitionName);
        }
    }

    @Override
    public void close(String partitionName) throws ObjectStoreException {
    }

    private void createPartition(String partitionName) throws ObjectStoreException {
        PersistentObjectStorePartition persistentObjectStorePartition = new PersistentObjectStorePartition(this.muleContext, partitionName, this.getNewPartitionDirectory());
        persistentObjectStorePartition.open();
        this.partitionsByName.put(partitionName, persistentObjectStorePartition);
    }

    private File getNewPartitionDirectory() {
        return new File(this.storeDirectory, UUID.getUUID());
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    public boolean contains(Serializable key, String partitionName) throws ObjectStoreException {
        return this.getPartitionObjectStore(partitionName).contains((Serializable)((Object)key.toString()));
    }

    @Override
    public void store(Serializable key, T value, String partitionName) throws ObjectStoreException {
        this.getPartitionObjectStore(partitionName).store((Serializable)((Object)key.toString()), value);
    }

    @Override
    public T retrieve(Serializable key, String partitionName) throws ObjectStoreException {
        return this.getPartitionObjectStore(partitionName).retrieve((Serializable)((Object)key.toString()));
    }

    @Override
    public T remove(Serializable key, String partitionName) throws ObjectStoreException {
        return this.getPartitionObjectStore(partitionName).remove((Serializable)((Object)key.toString()));
    }

    @Override
    public List<Serializable> allKeys(String partitionName) throws ObjectStoreException {
        return this.getPartitionObjectStore(partitionName).allKeys();
    }

    @Override
    public void clear(String partitionName) throws ObjectStoreException {
        this.getPartitionObjectStore(partitionName).clear();
    }

    private PersistentObjectStorePartition<T> getPartitionObjectStore(String partitionName) throws ObjectStoreException {
        if (!this.partitionsByName.containsKey(partitionName)) {
            throw new ObjectStoreException(CoreMessages.createStaticMessage("No partition named: " + partitionName));
        }
        return this.partitionsByName.get(partitionName);
    }

    @Override
    public List<String> allPartitions() throws ObjectStoreException {
        Object[] files = this.storeDirectory.listFiles();
        if (files == null) {
            return new ArrayList<String>();
        }
        Arrays.sort(files);
        ArrayList<String> partitions = new ArrayList<String>();
        for (Object file : files) {
            if (!((File)file).isDirectory()) continue;
            partitions.add(((File)file).getName());
        }
        return partitions;
    }

    private void initObjectStoreDirectory() {
        if (this.storeDirectory == null) {
            String workingDirectory = this.muleContext.getConfiguration().getWorkingDirectory();
            String path = workingDirectory + File.separator + OBJECT_STORE_DIR;
            this.storeDirectory = FileUtils.newFile(path);
            if (!this.storeDirectory.exists()) {
                this.createStoreDirectory(this.storeDirectory);
            }
        }
    }

    private synchronized void createStoreDirectory(File directory) {
        if (!directory.exists() && !directory.mkdirs()) {
            I18nMessage message = CoreMessages.failedToCreate("object store directory " + directory.getAbsolutePath());
            throw new MuleRuntimeException(message);
        }
    }

    private void loadPreviousStoredPartitions() throws ObjectStoreException {
        File[] directories = this.storeDirectory.listFiles(File::isDirectory);
        if (directories == null) {
            return;
        }
        for (File partitionDirectory : directories) {
            try {
                PersistentObjectStorePartition persistentObjectStorePartition = new PersistentObjectStorePartition(this.muleContext, partitionDirectory);
                persistentObjectStorePartition.open();
                this.partitionsByName.put(persistentObjectStorePartition.getPartitionName(), persistentObjectStorePartition);
            }
            catch (Exception e) {
                this.logger.error("Could not restore partition under directory " + partitionDirectory.getAbsolutePath());
            }
        }
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public void expire(long entryTTL, int maxEntries) throws ObjectStoreException {
        this.expire(entryTTL, maxEntries, "DEFAULT_PARTITION");
    }

    @Override
    public void disposePartition(String partitionName) throws ObjectStoreException {
        this.clear(partitionName);
    }

    @Override
    public void expire(long entryTTL, int maxEntries, String partitionName) throws ObjectStoreException {
        this.getPartitionObjectStore(partitionName).expire(entryTTL, maxEntries);
    }
}

