/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el;

import java.io.IOException;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.util.IOUtils;

public class ExpressionLanguageComponent
extends AbstractAnnotatedObject
implements Processor,
Initialisable {
    @Inject
    private ExtendedExpressionManager expressionMgr;
    protected FlowConstruct flowConstruct;
    protected String expression;
    protected String expressionFile;

    @Override
    public void initialise() throws InitialisationException {
        if (this.expressionFile != null) {
            try {
                this.expression = IOUtils.getResourceAsString(this.expressionFile, this.getClass());
            }
            catch (IOException e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        } else if (this.expression == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("expression"), (Initialisable)this);
        }
    }

    @Override
    public Event process(Event event) throws MuleException {
        Event.Builder eventBuilder = Event.builder(event);
        this.expressionMgr.evaluate(this.expression, event, eventBuilder, this.getLocation());
        return eventBuilder.build();
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void setExpressionFile(String expressionFile) {
        this.expressionFile = expressionFile;
    }
}

