/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.function;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import javax.xml.datatype.XMLGregorianCalendar;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.el.ExpressionLanguageContext;
import org.mule.runtime.core.api.el.ExpressionLanguageFunction;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.el.datetime.DateTime;

public class DateTimeExpressionLanguageFuntion
implements ExpressionLanguageFunction {
    @Override
    public Object call(Object[] params, ExpressionLanguageContext context) {
        int numParams = params.length;
        if (numParams < 1 || numParams > 3) {
            throw new IllegalArgumentException("invalid number of arguments");
        }
        if (numParams == 1) {
            Object dateParam = params[0];
            if (dateParam instanceof Date) {
                return new DateTime((Date)dateParam);
            }
            if (dateParam instanceof Calendar) {
                return new DateTime((Calendar)dateParam);
            }
            if (dateParam instanceof XMLGregorianCalendar) {
                return new DateTime((XMLGregorianCalendar)dateParam);
            }
            try {
                return new DateTime(dateParam.toString());
            }
            catch (RuntimeException e) {
                throw new ExpressionRuntimeException(CoreMessages.createStaticMessage("Unable to parse string as a ISO-8601 date"), (Throwable)e);
            }
        }
        try {
            return new DateTime((String)params[0], (String)params[1]);
        }
        catch (ParseException e) {
            throw new ExpressionRuntimeException(CoreMessages.createStaticMessage("Unable to parse string as a date using format '" + params[1] + "''"));
        }
    }
}

