/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.config.bootstrap;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.config.bootstrap.BootstrapService;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.transaction.TransactionFactory;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.util.PropertiesUtils;
import org.mule.runtime.core.internal.config.bootstrap.AbstractBootstrapProperty;
import org.mule.runtime.core.internal.config.bootstrap.ObjectBootstrapProperty;
import org.mule.runtime.core.internal.config.bootstrap.TransactionFactoryBootstrapProperty;
import org.mule.runtime.core.internal.config.bootstrap.TransformerBootstrapProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRegistryBootstrap
implements Initialisable {
    private static final String TRANSACTION_RESOURCE_SUFFIX = ".transaction.resource";
    private static final String OPTIONAL_ATTRIBUTE = "optional";
    private static final String RETURN_CLASS_PROPERTY = "returnClass";
    private static final String MIME_TYPE_PROPERTY = "mimeType";
    public static final String TRANSFORMER_KEY = ".transformer.";
    public static final String OBJECT_KEY = ".object.";
    public static final String SINGLE_TX = ".singletx.";
    protected ArtifactType artifactType = ArtifactType.APP;
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected MuleContext muleContext;

    public AbstractRegistryBootstrap(ArtifactType artifactType, MuleContext muleContext) {
        this.artifactType = artifactType;
        this.muleContext = muleContext;
    }

    @Override
    public void initialise() throws InitialisationException {
        List<BootstrapService> bootstrapServices;
        try {
            bootstrapServices = this.muleContext.getRegistryBootstrapServiceDiscoverer().discover();
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        int objectCounter = 1;
        LinkedList<TransformerBootstrapProperty> transformers = new LinkedList<TransformerBootstrapProperty>();
        LinkedList<ObjectBootstrapProperty> namedObjects = new LinkedList<ObjectBootstrapProperty>();
        LinkedList<ObjectBootstrapProperty> unnamedObjects = new LinkedList<ObjectBootstrapProperty>();
        LinkedList<TransactionFactoryBootstrapProperty> singleTransactionFactories = new LinkedList<TransactionFactoryBootstrapProperty>();
        for (BootstrapService bootstrapService : bootstrapServices) {
            Properties bootstrapProperties = bootstrapService.getProperties();
            for (Map.Entry<Object, Object> entry : bootstrapProperties.entrySet()) {
                String propertyKey = (String)entry.getKey();
                String propertyValue = (String)entry.getValue();
                if (propertyKey.contains(OBJECT_KEY)) {
                    String newKey = propertyKey.substring(0, propertyKey.lastIndexOf(".")) + objectCounter++;
                    unnamedObjects.add(this.createObjectBootstrapProperty(bootstrapService, newKey, propertyValue));
                    continue;
                }
                if (propertyKey.contains(TRANSFORMER_KEY)) {
                    transformers.add(this.createTransformerBootstrapProperty(bootstrapService, propertyValue));
                    continue;
                }
                if (propertyKey.contains(SINGLE_TX)) {
                    if (propertyKey.contains(TRANSACTION_RESOURCE_SUFFIX)) continue;
                    singleTransactionFactories.add(this.createTransactionFactoryBootstrapProperty(bootstrapService, bootstrapProperties, propertyKey, propertyValue));
                    continue;
                }
                namedObjects.add(this.createObjectBootstrapProperty(bootstrapService, propertyKey, propertyValue));
            }
        }
        try {
            this.registerUnnamedObjects(unnamedObjects);
            this.registerTransformers();
            this.registerTransformers(transformers);
            this.registerObjects(namedObjects);
            this.registerTransactionFactories(singleTransactionFactories, this.muleContext);
        }
        catch (Exception e1) {
            throw new InitialisationException((Throwable)e1, (Initialisable)this);
        }
    }

    private TransformerBootstrapProperty createTransformerBootstrapProperty(BootstrapService bootstrapService, String propertyValue) {
        int i;
        String name = null;
        boolean optional = false;
        String transString = propertyValue;
        String returnClassName = null;
        int index = transString.indexOf(",");
        if (index > -1) {
            Properties p = PropertiesUtils.getPropertiesFromString(transString.substring(index + 1), ',');
            name = p.getProperty("name", null);
            returnClassName = p.getProperty(RETURN_CLASS_PROPERTY, null);
            optional = p.containsKey(OPTIONAL_ATTRIBUTE);
        }
        String mime = null;
        if (returnClassName != null && (i = returnClassName.indexOf(":")) > -1) {
            mime = returnClassName.substring(i + 1);
            returnClassName = returnClassName.substring(0, i);
        }
        String className = index == -1 ? transString : transString.substring(0, index);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(MIME_TYPE_PROPERTY, mime);
        properties.put(RETURN_CLASS_PROPERTY, returnClassName);
        return new TransformerBootstrapProperty(bootstrapService, ArtifactType.APP, optional, name, className, returnClassName, mime);
    }

    private TransactionFactoryBootstrapProperty createTransactionFactoryBootstrapProperty(BootstrapService bootstrapService, Properties bootstrapProperties, String propertyKey, String propertyValue) throws InitialisationException {
        String transactionResourceKey = propertyKey.replace(".transaction.factory", TRANSACTION_RESOURCE_SUFFIX);
        String transactionResource = bootstrapProperties.getProperty(transactionResourceKey);
        if (transactionResource == null) {
            throw new InitialisationException(CoreMessages.createStaticMessage(String.format("There is no transaction resource specified for transaction factory %s", propertyKey)), (Initialisable)this);
        }
        String transactionResourceClassNameProperties = transactionResource;
        boolean optional = false;
        int index = transactionResourceClassNameProperties.indexOf(",");
        if (index > -1) {
            Properties p = PropertiesUtils.getPropertiesFromString(transactionResourceClassNameProperties.substring(index + 1), ',');
            optional = p.containsKey(OPTIONAL_ATTRIBUTE);
        }
        String transactionResourceClassName = index == -1 ? transactionResourceClassNameProperties : transactionResourceClassNameProperties.substring(0, index);
        return new TransactionFactoryBootstrapProperty(bootstrapService, ArtifactType.APP, optional, propertyValue, transactionResourceClassName);
    }

    private ObjectBootstrapProperty createObjectBootstrapProperty(BootstrapService bootstrapService, String propertyKey, String propertyValue) {
        String className;
        boolean optional = false;
        ArtifactType artifactTypeParameterValue = ArtifactType.APP;
        String value = propertyValue;
        int index = value.indexOf(",");
        if (index > -1) {
            Properties p = PropertiesUtils.getPropertiesFromString(value.substring(index + 1), ',');
            if (p.containsKey("applyToArtifactType")) {
                artifactTypeParameterValue = ArtifactType.createFromString((String)p.get("applyToArtifactType"));
            }
            optional = p.containsKey(OPTIONAL_ATTRIBUTE);
            className = value.substring(0, index);
        } else {
            className = value;
        }
        return new ObjectBootstrapProperty(bootstrapService, artifactTypeParameterValue, optional, propertyKey, className);
    }

    private void registerUnnamedObjects(List<ObjectBootstrapProperty> bootstrapProperties) throws Exception {
        for (ObjectBootstrapProperty bootstrapProperty : bootstrapProperties) {
            this.registerObject(bootstrapProperty);
        }
    }

    private void registerObjects(List<ObjectBootstrapProperty> bootstrapProperties) throws Exception {
        for (ObjectBootstrapProperty bootstrapProperty : bootstrapProperties) {
            this.registerObject(bootstrapProperty);
        }
    }

    private void registerObject(ObjectBootstrapProperty bootstrapProperty) throws Exception {
        try {
            if (!bootstrapProperty.getArtifactType().equals((Object)ArtifactType.ALL) && !bootstrapProperty.getArtifactType().equals((Object)this.artifactType)) {
                return;
            }
            this.doRegisterObject(bootstrapProperty);
        }
        catch (InvocationTargetException e) {
            Throwable cause = ExceptionUtils.getCause((Throwable)e);
            this.throwExceptionIfNotOptional(cause instanceof NoClassDefFoundError && bootstrapProperty.getOptional() != false, cause, bootstrapProperty);
        }
        catch (ClassNotFoundException | NoClassDefFoundError | NoSuchMethodException e) {
            this.throwExceptionIfNotOptional(bootstrapProperty.getOptional(), e, bootstrapProperty);
        }
    }

    private void registerTransactionFactories(List<TransactionFactoryBootstrapProperty> singleTransactionFactories, MuleContext context) throws Exception {
        for (TransactionFactoryBootstrapProperty bootstrapProperty : singleTransactionFactories) {
            try {
                Class supportedType = bootstrapProperty.getService().forName(bootstrapProperty.getTransactionResourceClassName());
                context.getTransactionFactoryManager().registerTransactionFactory(supportedType, (TransactionFactory)bootstrapProperty.getService().instantiateClass(bootstrapProperty.getTransactionFactoryClassName(), new Object[0]));
            }
            catch (ClassNotFoundException | NoClassDefFoundError ncdfe) {
                this.throwExceptionIfNotOptional(bootstrapProperty.getOptional(), ncdfe, bootstrapProperty);
            }
        }
    }

    private void registerTransformers(List<TransformerBootstrapProperty> props) throws Exception {
        for (TransformerBootstrapProperty bootstrapProperty : props) {
            Class transformerClass = bootstrapProperty.getService().forName(bootstrapProperty.getClassName());
            try {
                Class returnClass = null;
                String returnClassString = bootstrapProperty.getReturnClassName();
                if (returnClassString != null) {
                    returnClass = returnClassString.equals("byte[]") ? byte[].class : bootstrapProperty.getService().forName(returnClassString);
                }
                this.doRegisterTransformer(bootstrapProperty, returnClass, transformerClass);
            }
            catch (InvocationTargetException e) {
                Throwable cause = ExceptionUtils.getCause((Throwable)e);
                this.throwExceptionIfNotOptional(cause instanceof NoClassDefFoundError && bootstrapProperty.getOptional() != false, cause, bootstrapProperty);
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                this.throwExceptionIfNotOptional(bootstrapProperty.getOptional(), e, bootstrapProperty);
            }
        }
    }

    protected abstract void doRegisterTransformer(TransformerBootstrapProperty var1, Class<?> var2, Class<? extends Transformer> var3) throws Exception;

    protected abstract void registerTransformers() throws MuleException;

    protected abstract void doRegisterObject(ObjectBootstrapProperty var1) throws Exception;

    private void throwExceptionIfNotOptional(boolean optional, Throwable t, AbstractBootstrapProperty bootstrapProperty) throws Exception {
        if (optional) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Ignoring optional " + bootstrapProperty);
            }
        } else {
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new Exception(t);
        }
    }
}

