/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.GlobalNameableObject;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.notification.EnrichedNotificationInfo;
import org.mule.runtime.core.api.context.notification.ExceptionNotification;
import org.mule.runtime.core.api.context.notification.SecurityNotification;
import org.mule.runtime.core.api.context.notification.ServerNotification;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.exception.TypedException;
import org.mule.runtime.core.api.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.api.processor.AbstractMessageProcessorOwner;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.config.ExceptionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExceptionListener
extends AbstractMessageProcessorOwner
implements GlobalNameableObject {
    protected static final String NOT_SET = "<not set>";
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected List<Processor> messageProcessors = new CopyOnWriteArrayList<Processor>();
    protected AtomicBoolean initialised = new AtomicBoolean(false);
    protected boolean enableNotifications = true;
    protected String logException = Boolean.TRUE.toString();
    protected String globalName;

    @Override
    public String getGlobalName() {
        return this.globalName;
    }

    @Override
    public void setGlobalName(String globalName) {
        this.globalName = globalName;
    }

    public List<Processor> getMessageProcessors() {
        return this.messageProcessors;
    }

    public void setMessageProcessors(List<Processor> processors) {
        if (processors == null) {
            throw new IllegalArgumentException("List of targets = null");
        }
        this.messageProcessors.clear();
        this.messageProcessors.addAll(processors);
    }

    @Override
    public final synchronized void initialise() throws InitialisationException {
        if (!this.initialised.get()) {
            this.doInitialise(this.muleContext);
            super.initialise();
            this.initialised.set(true);
        }
    }

    protected void doInitialise(MuleContext context) throws InitialisationException {
        Objects.requireNonNull(this.muleContext);
        this.logger.info("Initialising exception listener: " + this.toString());
    }

    protected void fireNotification(Exception ex, Event event) {
        if (this.enableNotifications) {
            if (ex.getCause() != null && this.getCause(ex) instanceof SecurityException) {
                this.fireNotification(new SecurityNotification((SecurityException)this.getCause(ex), 401));
            } else {
                this.fireNotification(new ExceptionNotification(EnrichedNotificationInfo.createInfo(event, ex, null), this.getLocation()));
            }
        }
    }

    private Throwable getCause(Exception ex) {
        return ex.getCause() instanceof TypedException ? ex.getCause().getCause() : ex.getCause();
    }

    protected void doLogException(Throwable t) {
        MuleException muleException = ExceptionHelper.getRootMuleException(t);
        if (muleException != null) {
            this.logger.error(muleException.getDetailedMessage());
        } else {
            this.logger.error("Caught exception in Exception Strategy: " + t.getMessage(), t);
        }
    }

    protected void logFatal(Event event, Throwable t) {
        FlowConstructStatistics statistics = this.flowConstruct.getStatistics();
        if (statistics != null && statistics.isEnabled()) {
            statistics.incFatalError();
        }
        String logUniqueId = StringUtils.defaultString((String)event.getCorrelationId(), (String)NOT_SET);
        String printableLogMessage = MessageFormat.format("Message identification summary here: id={0}, correlation={1}", logUniqueId, event.getGroupCorrelation());
        this.logger.error("Failed to dispatch message to error queue after it failed to process.  This may cause message loss. " + (event.getMessage() == null ? "" : printableLogMessage), t);
    }

    public boolean isInitialised() {
        return this.initialised.get();
    }

    protected void fireNotification(ServerNotification notification) {
        if (this.muleContext != null) {
            this.muleContext.fireNotification(notification);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.debug("MuleContext is not yet available for firing notifications, ignoring event: " + notification);
        }
    }

    public boolean isEnableNotifications() {
        return this.enableNotifications;
    }

    public void setEnableNotifications(boolean enableNotifications) {
        this.enableNotifications = enableNotifications;
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return this.messageProcessors;
    }

    protected void commit() {
        TransactionCoordination.getInstance().commitCurrentTransaction();
    }

    protected void rollback(Exception ex) {
        if (TransactionCoordination.getInstance().getTransaction() != null) {
            TransactionCoordination.getInstance().rollbackCurrentTransaction();
        }
        if (ex instanceof MessagingException) {
            MessagingException messagingException = (MessagingException)ex;
            messagingException.setCauseRollback(true);
        }
    }
}

