/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connector.ConnectException;
import org.mule.runtime.core.api.exception.RollbackSourceCallback;
import org.mule.runtime.core.api.exception.SystemExceptionHandler;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.exception.AbstractExceptionListener;
import org.mule.runtime.core.internal.message.DefaultExceptionPayload;
import org.mule.runtime.core.internal.message.InternalMessage;

public abstract class AbstractSystemExceptionStrategy
extends AbstractExceptionListener
implements SystemExceptionHandler {
    protected Scheduler retryScheduler;

    @Override
    public void handleException(Exception ex, RollbackSourceCallback rollbackMethod) {
        this.fireNotification(ex, Event.getCurrentEvent());
        this.doLogException(ex);
        this.logger.debug("Rolling back transaction");
        this.rollback(ex, rollbackMethod);
        DefaultExceptionPayload exceptionPayload = new DefaultExceptionPayload(ex);
        if (Event.getCurrentEvent() != null) {
            Event currentEvent = Event.getCurrentEvent();
            currentEvent = Event.builder(currentEvent).message(InternalMessage.builder(currentEvent.getMessage()).exceptionPayload(exceptionPayload).build()).build();
            Event.setCurrentEvent(currentEvent);
        }
        if (ex instanceof ConnectException) {
            ((ConnectException)ex).handleReconnection(this.retryScheduler);
        }
    }

    private void rollback(Exception ex, RollbackSourceCallback rollbackMethod) {
        if (TransactionCoordination.getInstance().getTransaction() != null) {
            this.rollback(ex);
        }
        if (rollbackMethod != null) {
            rollbackMethod.rollback();
        }
    }

    @Override
    public void handleException(Exception ex) {
        this.handleException(ex, null);
    }

    @Override
    protected void doInitialise(MuleContext context) throws InitialisationException {
        this.retryScheduler = this.muleContext.getSchedulerService().ioScheduler(this.muleContext.getSchedulerBaseConfig().withShutdownTimeout(0L, TimeUnit.MILLISECONDS));
        super.doInitialise(context);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.retryScheduler != null) {
            this.retryScheduler.stop();
            this.retryScheduler = null;
        }
    }
}

