/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.exception.MessageRedeliveredException;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.exception.RedeliveryExceeded;
import org.mule.runtime.core.internal.exception.TemplateOnErrorHandler;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class OnErrorPropagateHandler
extends TemplateOnErrorHandler {
    private RedeliveryExceeded redeliveryExceeded;
    private Integer maxRedeliveryAttempts;

    @Override
    protected void doInitialise(MuleContext muleContext) throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.redeliveryExceeded);
        super.doInitialise(muleContext);
    }

    public void setRedeliveryExceeded(RedeliveryExceeded redeliveryExceeded) {
        this.redeliveryExceeded = redeliveryExceeded;
    }

    public void setMaxRedeliveryAttempts(Integer maxRedeliveryAttempts) {
        this.maxRedeliveryAttempts = maxRedeliveryAttempts;
    }

    public Integer getMaxRedeliveryAttempts() {
        return this.maxRedeliveryAttempts;
    }

    public boolean hasMaxRedeliveryAttempts() {
        return this.maxRedeliveryAttempts != null;
    }

    @Override
    protected Function<Event, Event> beforeRouting(MessagingException exception) {
        return event -> {
            event = super.beforeRouting(exception).apply((Event)event);
            if (!this.isRedeliveryExhausted(exception)) {
                this.rollback(exception);
            }
            return event;
        };
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        ArrayList<Processor> messageProcessors = new ArrayList<Processor>(super.getOwnedMessageProcessors().size() + (this.redeliveryExceeded == null ? 0 : this.redeliveryExceeded.getMessageProcessors().size()));
        messageProcessors.addAll(super.getOwnedMessageProcessors());
        if (this.redeliveryExceeded != null) {
            messageProcessors.addAll(this.redeliveryExceeded.getMessageProcessors());
        }
        return messageProcessors;
    }

    private boolean isRedeliveryExhausted(Exception exception) {
        return exception instanceof MessageRedeliveredException;
    }

    @Override
    protected Function<Event, Publisher<Event>> route(MessagingException exception) {
        if (this.isRedeliveryExhausted(exception)) {
            if (this.redeliveryExceeded != null) {
                this.markExceptionAsHandled(exception);
                return event -> Mono.just((Object)event).transform((Function)this.redeliveryExceeded);
            }
        } else {
            return super.route(exception);
        }
        this.logger.info("Message redelivery exhausted. No redelivery exhausted actions configured. Message consumed.");
        return event -> Mono.just((Object)event);
    }

    @Override
    protected Event processReplyTo(Event event, Exception e) {
        if (this.isRedeliveryExhausted(e)) {
            return super.processReplyTo(event, e);
        }
        return event;
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
        if (this.redeliveryExceeded != null) {
            this.redeliveryExceeded.setFlowConstruct(flowConstruct);
        }
    }
}

