/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.notification.EnrichedNotificationInfo;
import org.mule.runtime.core.api.context.notification.ErrorHandlerNotification;
import org.mule.runtime.core.api.exception.DisjunctiveErrorTypeMatcher;
import org.mule.runtime.core.api.exception.ErrorTypeMatcher;
import org.mule.runtime.core.api.exception.ErrorTypeRepository;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.exception.MessagingExceptionHandlerAcceptor;
import org.mule.runtime.core.api.exception.SingleErrorTypeMatcher;
import org.mule.runtime.core.api.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.exception.AbstractExceptionListener;
import org.mule.runtime.core.internal.exception.MessagingExceptionHandlerToSystemAdapter;
import org.mule.runtime.core.internal.message.DefaultExceptionPayload;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.privileged.routing.requestreply.ReplyToPropertyRequestReplyReplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public abstract class TemplateOnErrorHandler
extends AbstractExceptionListener
implements MessagingExceptionHandlerAcceptor {
    private MessageProcessorChain configuredMessageProcessors;
    private Processor replyToMessageProcessor = new ReplyToPropertyRequestReplyReplier();
    private String when;
    private boolean handleException;
    protected String errorType = null;
    protected ErrorTypeMatcher errorTypeMatcher = null;

    @Override
    public final Event handleException(MessagingException exception, Event event) {
        try {
            return (Event)Mono.from(this.applyInternal(exception, event)).block();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(Exceptions.unwrap(throwable));
        }
    }

    @Override
    public Publisher<Event> apply(MessagingException exception) {
        return this.applyInternal(exception, exception.getEvent());
    }

    private Publisher<Event> applyInternal(MessagingException exception, Event event) {
        return Mono.just((Object)event).map(this.beforeRouting(exception)).flatMapMany(this.route(exception)).last().map(this.afterRouting(exception)).doOnError(MessagingException.class, this.onRoutingError()).handle((result, sink) -> {
            if (exception.handled()) {
                sink.next(result);
            } else {
                exception.setProcessedEvent((Event)result);
                sink.error((Throwable)exception);
            }
        }).doOnTerminate((result, throwable) -> this.fireEndNotification(event, (Event)result, (Throwable)throwable));
    }

    private Consumer<MessagingException> onRoutingError() {
        return me -> {
            try {
                me.setInErrorHandler(true);
                this.logger.error("Exception during exception strategy execution");
                this.doLogException((Throwable)me);
                TransactionCoordination.getInstance().rollbackCurrentTransaction();
            }
            catch (Exception ex) {
                this.logger.warn(ex.getMessage());
            }
        };
    }

    private void fireEndNotification(Event event, Event result, Throwable throwable) {
        this.muleContext.getNotificationManager().fireNotification(new ErrorHandlerNotification(EnrichedNotificationInfo.createInfo(result != null ? result : event, throwable instanceof MessagingException ? (MessagingException)throwable : null, this.configuredMessageProcessors), this.getLocation(), 2002));
    }

    protected Function<Event, Publisher<Event>> route(MessagingException exception) {
        return event -> {
            if (this.getMessageProcessors().isEmpty()) {
                return Mono.just((Object)event);
            }
            event = Event.builder(event).message(InternalMessage.builder(event.getMessage()).exceptionPayload(new DefaultExceptionPayload(exception)).build()).build();
            return Mono.from(MessageProcessors.processWithChildContext(event, this.configuredMessageProcessors, Optional.ofNullable(this.getLocation()), new MessagingExceptionHandlerToSystemAdapter(this.muleContext)));
        };
    }

    @Override
    public void setMessageProcessors(List<Processor> processors) {
        super.setMessageProcessors(processors);
        this.configuredMessageProcessors = MessageProcessors.newChain(this.getMessageProcessors());
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return this.configuredMessageProcessors == null ? new ArrayList() : Collections.singletonList(this.configuredMessageProcessors);
    }

    private void markExceptionAsHandledIfRequired(Exception exception) {
        if (this.handleException) {
            this.markExceptionAsHandled(exception);
        }
    }

    protected void markExceptionAsHandled(Exception exception) {
        if (exception instanceof MessagingException) {
            ((MessagingException)exception).setHandled(true);
        }
    }

    protected Event processReplyTo(Event event, Exception e) {
        try {
            return this.replyToMessageProcessor.process(event);
        }
        catch (MuleException ex) {
            this.logFatal(event, ex);
            return event;
        }
    }

    protected Event nullifyExceptionPayloadIfRequired(Event event) {
        if (this.handleException) {
            return Event.builder(event).error(null).message(InternalMessage.builder(event.getMessage()).exceptionPayload(null).build()).build();
        }
        return event;
    }

    private void processStatistics() {
        FlowConstructStatistics statistics = this.flowConstruct.getStatistics();
        if (statistics != null && statistics.isEnabled()) {
            statistics.incExecutionError();
        }
    }

    @Override
    protected void doInitialise(MuleContext muleContext) throws InitialisationException {
        super.doInitialise(muleContext);
        if (this.configuredMessageProcessors != null) {
            this.configuredMessageProcessors.setFlowConstruct(this.flowConstruct);
            this.configuredMessageProcessors.setMuleContext(muleContext);
        }
        this.errorTypeMatcher = TemplateOnErrorHandler.createErrorType(muleContext.getErrorTypeRepository(), this.errorType);
    }

    public static ErrorTypeMatcher createErrorType(ErrorTypeRepository errorTypeRepository, String errorTypeNames) {
        if (errorTypeNames == null) {
            return null;
        }
        String[] errorTypeIdentifiers = errorTypeNames.split(",");
        List<ErrorTypeMatcher> matchers = Arrays.stream(errorTypeIdentifiers).map(identifier -> {
            String parsedIdentifier = identifier.trim();
            return new SingleErrorTypeMatcher(errorTypeRepository.lookupErrorType(ComponentIdentifier.buildFromStringRepresentation(parsedIdentifier)).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not find ErrorType for the given identifier: '%s'", parsedIdentifier))));
        }).collect(Collectors.toList());
        return new DisjunctiveErrorTypeMatcher(matchers);
    }

    public void setWhen(String when) {
        this.when = when;
    }

    @Override
    public boolean accept(Event event) {
        return this.acceptsAll() || this.acceptsErrorType(event) || this.when != null && this.muleContext.getExpressionManager().evaluateBoolean(this.when, event, this.getLocation());
    }

    private boolean acceptsErrorType(Event event) {
        return this.errorTypeMatcher != null && this.errorTypeMatcher.match(event.getError().get().getErrorType());
    }

    @Override
    public boolean acceptsAll() {
        return this.errorTypeMatcher == null && this.when == null;
    }

    protected Function<Event, Event> afterRouting(MessagingException exception) {
        return event -> {
            if (event != null) {
                event = this.processReplyTo((Event)event, exception);
                return this.nullifyExceptionPayloadIfRequired((Event)event);
            }
            return event;
        };
    }

    protected Function<Event, Event> beforeRouting(MessagingException exception) {
        return event -> {
            this.muleContext.getNotificationManager().fireNotification(new ErrorHandlerNotification(EnrichedNotificationInfo.createInfo(event, exception, this.configuredMessageProcessors), this.getLocation(), 2001));
            this.fireNotification(exception, (Event)event);
            this.logException(exception, (Event)event);
            this.processStatistics();
            exception.setInErrorHandler(false);
            this.markExceptionAsHandledIfRequired(exception);
            return event;
        };
    }

    protected void logException(Throwable t, Event event) {
        if (Boolean.TRUE.toString().equals(this.logException) || this.muleContext.getExpressionManager().evaluateBoolean(this.logException, event, this.getLocation(), true, true)) {
            this.doLogException(t);
        }
    }

    public void setHandleException(boolean handleException) {
        this.handleException = handleException;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }
}

