/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.policy.Policy;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public abstract class AbstractCompositePolicy<ParametersTransformer, ParametersProcessor> {
    private final List<Policy> parameterizedPolicies;
    private final Optional<ParametersTransformer> parametersTransformer;
    private final ParametersProcessor parametersProcessor;

    public AbstractCompositePolicy(List<Policy> policies, Optional<ParametersTransformer> parametersTransformer, ParametersProcessor parametersProcessor) {
        Preconditions.checkArgument(!policies.isEmpty(), "policies list cannot be empty");
        this.parameterizedPolicies = policies;
        this.parametersTransformer = parametersTransformer;
        this.parametersProcessor = parametersProcessor;
    }

    public final Publisher<Event> processPolicies(Event operationEvent) {
        return Mono.just((Object)operationEvent).flatMapMany(event -> MessageProcessors.processWithChildContext(event, new NextOperationCall(), Optional.empty()));
    }

    protected Optional<ParametersTransformer> getParametersTransformer() {
        return this.parametersTransformer;
    }

    protected ParametersProcessor getParametersProcessor() {
        return this.parametersProcessor;
    }

    protected abstract Publisher<Event> processNextOperation(Event var1);

    protected abstract Publisher<Event> processPolicy(Policy var1, Processor var2, Event var3);

    public class NextOperationCall
    extends AbstractAnnotatedObject
    implements Processor {
        private int index = 0;

        @Override
        public Event process(Event event) throws MuleException {
            return MessageProcessors.processToApply(event, this);
        }

        @Override
        public Publisher<Event> apply(Publisher<Event> publisher) {
            return Mono.from(publisher).then(event -> {
                Preconditions.checkState(this.index <= AbstractCompositePolicy.this.parameterizedPolicies.size(), "composite policy index is greater that the number of policies.");
                if (this.index == AbstractCompositePolicy.this.parameterizedPolicies.size()) {
                    return Mono.from(AbstractCompositePolicy.this.processNextOperation((Event)event));
                }
                return Mono.from(AbstractCompositePolicy.this.processPolicy((Policy)AbstractCompositePolicy.this.parameterizedPolicies.get(this.index++), this, (Event)event));
            }).onErrorMap(throwable -> !(throwable instanceof MuleException), throwable -> new DefaultMuleException((Throwable)throwable));
        }
    }
}

