/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.policy.OperationPolicyParametersTransformer;
import org.mule.runtime.core.api.policy.Policy;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.policy.AbstractCompositePolicy;
import org.mule.runtime.core.internal.policy.OperationExecutionFunction;
import org.mule.runtime.core.internal.policy.OperationParametersProcessor;
import org.mule.runtime.core.internal.policy.OperationPolicy;
import org.mule.runtime.core.internal.policy.OperationPolicyProcessorFactory;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class CompositeOperationPolicy
extends AbstractCompositePolicy<OperationPolicyParametersTransformer, OperationParametersProcessor>
implements OperationPolicy {
    private final Processor nextOperation;
    private final OperationPolicyProcessorFactory operationPolicyProcessorFactory;
    private Event nextOperationResponse;

    public CompositeOperationPolicy(List<Policy> parameterizedPolicies, final Optional<OperationPolicyParametersTransformer> operationPolicyParametersTransformer, OperationPolicyProcessorFactory operationPolicyProcessorFactory, final OperationParametersProcessor operationParametersProcessor, final OperationExecutionFunction operationExecutionFunction) {
        super(parameterizedPolicies, operationPolicyParametersTransformer, operationParametersProcessor);
        this.nextOperation = new Processor(){

            @Override
            public Event process(Event event) throws MuleException {
                return MessageProcessors.processToApply(event, this);
            }

            @Override
            public Publisher<Event> apply(Publisher<Event> publisher) {
                return Mono.from(publisher).flatMap(event -> {
                    HashMap<String, Object> parametersMap = new HashMap<String, Object>();
                    try {
                        parametersMap.putAll(operationParametersProcessor.getOperationParameters());
                    }
                    catch (Exception e) {
                        return Mono.error((Throwable)e);
                    }
                    if (operationPolicyParametersTransformer.isPresent()) {
                        parametersMap.putAll(((OperationPolicyParametersTransformer)operationPolicyParametersTransformer.get()).fromMessageToParameters(event.getMessage()));
                    }
                    return Mono.from(operationExecutionFunction.execute((Map<String, Object>)parametersMap, (Event)event));
                });
            }
        };
        this.operationPolicyProcessorFactory = operationPolicyProcessorFactory;
    }

    @Override
    protected Publisher<Event> processNextOperation(Event event) {
        return Mono.just((Object)event).transform((Function)this.nextOperation).doOnNext(response -> {
            this.nextOperationResponse = response;
        });
    }

    @Override
    protected Publisher<Event> processPolicy(Policy policy, Processor nextProcessor, Event event) {
        Processor defaultOperationPolicy = this.operationPolicyProcessorFactory.createOperationPolicy(policy, nextProcessor);
        return Mono.just((Object)event).transform((Function)defaultOperationPolicy).map(policyResponse -> this.nextOperationResponse);
    }

    @Override
    public Publisher<Event> process(Event operationEvent) {
        try {
            Message message = this.getParametersTransformer().isPresent() ? ((OperationPolicyParametersTransformer)this.getParametersTransformer().get()).fromParametersToMessage(((OperationParametersProcessor)this.getParametersProcessor()).getOperationParameters()) : operationEvent.getMessage();
            return this.processPolicies(Event.builder(operationEvent).message(message).build());
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }
}

