/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.map.MultiValueMap;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.policy.PolicyStateHandler;
import org.mule.runtime.core.api.policy.PolicyStateId;
import org.mule.runtime.core.api.processor.Processor;

public class DefaultPolicyStateHandler
implements PolicyStateHandler {
    private MultiValueMap policyStateIdsByExecutionIdentifier = new MultiValueMap();
    private Map<PolicyStateId, Event> stateMap = new HashMap<PolicyStateId, Event>();
    private Map<String, Processor> nextOperationMap = new HashMap<String, Processor>();

    @Override
    public void updateNextOperation(String identifier, Processor nextOperation) {
        this.nextOperationMap.put(identifier, nextOperation);
    }

    @Override
    public Processor retrieveNextOperation(String identifier) {
        return this.nextOperationMap.get(identifier);
    }

    @Override
    public Optional<Event> getLatestState(PolicyStateId identifier) {
        return Optional.ofNullable(this.stateMap.get(identifier));
    }

    @Override
    public void updateState(PolicyStateId identifier, Event lastStateEvent) {
        this.stateMap.put(identifier, lastStateEvent);
        this.policyStateIdsByExecutionIdentifier.put((Object)identifier.getExecutionIdentifier(), (Object)identifier);
    }

    @Override
    public void destroyState(String identifier) {
        Collection policyStateIds = this.policyStateIdsByExecutionIdentifier.getCollection((Object)identifier);
        if (policyStateIds != null) {
            policyStateIds.stream().forEach(this.stateMap::remove);
        }
        this.policyStateIdsByExecutionIdentifier.remove((Object)identifier);
        this.nextOperationMap.remove(identifier);
    }
}

