/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.execution.ExecutionCallback;
import org.mule.runtime.core.api.execution.TransactionalExecutionTemplate;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.AbstractMessageProcessorOwner;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.Scope;
import org.mule.runtime.core.api.transaction.MuleTransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class TryScope
extends AbstractMessageProcessorOwner
implements Scope {
    private static final Logger LOGGER = LoggerFactory.getLogger(TryScope.class);
    protected MessageProcessorChain nestedChain;
    protected MuleTransactionConfig transactionConfig;
    private MessagingExceptionHandler messagingExceptionHandler;

    @Override
    public Event process(Event event) throws MuleException {
        if (this.nestedChain == null) {
            return event;
        }
        TransactionalExecutionTemplate executionTemplate = TransactionalExecutionTemplate.createScopeTransactionalExecutionTemplate(this.muleContext, this.transactionConfig);
        ExecutionCallback<Event> processingCallback = () -> {
            Event e = MessageProcessors.processToApply(event, p -> Flux.from((Publisher)p).flatMap(request -> MessageProcessors.processWithChildContext(request, this.nestedChain, Optional.ofNullable(this.getLocation()), this.messagingExceptionHandler)));
            return e;
        };
        try {
            return executionTemplate.execute(processingCallback);
        }
        catch (MuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DefaultMuleException(CoreMessages.errorInvokingMessageProcessorWithinTransaction(this.nestedChain, this.transactionConfig), (Throwable)e);
        }
    }

    @Override
    public Publisher<Event> apply(Publisher<Event> publisher) {
        if (this.nestedChain == null) {
            return publisher;
        }
        if (TransactionCoordination.isTransactionActive() || this.transactionConfig.getAction() != 6) {
            return Scope.super.apply(publisher);
        }
        return Flux.from(publisher).flatMap(event -> MessageProcessors.processWithChildContext(event, this.nestedChain, Optional.ofNullable(this.getLocation()), this.messagingExceptionHandler));
    }

    public void setExceptionListener(MessagingExceptionHandler exceptionListener) {
        this.messagingExceptionHandler = exceptionListener;
    }

    public void setTransactionConfig(MuleTransactionConfig transactionConfig) {
        this.transactionConfig = transactionConfig;
    }

    public MuleTransactionConfig getTransactionConfig() {
        return this.transactionConfig;
    }

    public void setMessageProcessors(List<Processor> processors) {
        this.nestedChain = MessageProcessors.newChain(processors);
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.messagingExceptionHandler == null) {
            this.messagingExceptionHandler = this.muleContext.getDefaultErrorHandler();
        }
        LifecycleUtils.setFlowConstructIfNeeded(this.messagingExceptionHandler, this.flowConstruct);
        LifecycleUtils.initialiseIfNeeded((Object)this.messagingExceptionHandler, true, this.muleContext);
        super.initialise();
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.messagingExceptionHandler, LOGGER);
        super.dispose();
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.messagingExceptionHandler);
        super.start();
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.messagingExceptionHandler);
        super.stop();
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return Collections.singletonList(this.nestedChain);
    }
}

