/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.chain;

import java.util.List;
import java.util.function.Consumer;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.context.notification.FlowStackElement;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.context.notification.DefaultFlowCallStack;
import org.mule.runtime.core.internal.processor.chain.ExplicitMessageProcessorChainBuilder;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SubflowMessageProcessorChainBuilder
extends ExplicitMessageProcessorChainBuilder {
    @Override
    protected MessageProcessorChain createInterceptingChain(Processor head, List<Processor> processors, List<Processor> processorForLifecycle) {
        return new SubFlowMessageProcessorChain(this.name, head, processors, processorForLifecycle);
    }

    static class SubFlowMessageProcessorChain
    extends ExplicitMessageProcessorChainBuilder.ExplicitMessageProcessorChain {
        private String subFlowName;

        SubFlowMessageProcessorChain(String name, Processor head, List<Processor> processors, List<Processor> processorsForLifecycle) {
            super(name, head, processors, processorsForLifecycle);
            this.subFlowName = name;
        }

        private Consumer<Event> pushSubFlowFlowStackElement() {
            return event -> ((DefaultFlowCallStack)event.getFlowCallStack()).push(new FlowStackElement(this.subFlowName, null));
        }

        private Consumer<Event> popSubFlowFlowStackElement() {
            return event -> ((DefaultFlowCallStack)event.getFlowCallStack()).pop();
        }

        @Override
        public Publisher<Event> apply(Publisher<Event> publisher) {
            return Flux.from(publisher).concatMap(event -> Mono.just((Object)event).doOnNext(this.pushSubFlowFlowStackElement()).transform(s -> super.apply((Publisher)s)).doOnTerminate((event1, throwable) -> this.popSubFlowFlowStackElement().accept((Event)event)));
        }
    }
}

