/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.retry;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.retry.RetryContext;

public class DefaultRetryContext
implements RetryContext,
MuleContextAware {
    private Message[] returnMessages;
    private Map<Object, Object> metaInfo = new HashMap<Object, Object>();
    private String description;
    private Throwable lastFailure;
    private boolean failed = false;
    private MuleContext muleContext;

    public DefaultRetryContext(String description, Map<Object, Object> metaInfo) {
        this.description = description;
        if (metaInfo != null) {
            this.metaInfo = metaInfo;
        }
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    @Override
    public Map<Object, Object> getMetaInfo() {
        return Collections.unmodifiableMap(this.metaInfo);
    }

    @Override
    public Message[] getReturnMessages() {
        return this.returnMessages;
    }

    @Override
    public Message getFirstReturnMessage() {
        return this.returnMessages == null ? null : this.returnMessages[0];
    }

    @Override
    public void setReturnMessages(Message[] returnMessages) {
        this.returnMessages = returnMessages;
    }

    @Override
    public void addReturnMessage(Message result) {
        if (this.returnMessages == null) {
            this.returnMessages = new Message[]{result};
        } else {
            Message[] newReturnMessages = new Message[this.returnMessages.length + 1];
            System.arraycopy(newReturnMessages, 0, this.returnMessages, 0, 1);
            this.returnMessages = newReturnMessages;
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Throwable getLastFailure() {
        return this.lastFailure;
    }

    @Override
    public void setOk() {
        this.failed = false;
        this.lastFailure = null;
    }

    @Override
    public boolean isOk() {
        return !this.failed;
    }

    @Override
    public void setFailed(Throwable lastFailure) {
        this.failed = true;
        this.lastFailure = lastFailure;
    }
}

