/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.Collections;
import java.util.Map;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.internal.config.ExceptionHelper;

public class CompositeRoutingException
extends MuleException {
    private static final String MESSAGE_TITLE = "Exception(s) were found for route(s): ";
    private static final long serialVersionUID = -4421728527040579607L;
    private final Map<Integer, Throwable> exceptions;

    public CompositeRoutingException(I18nMessage message, Map<Integer, Throwable> exceptions) {
        super(message);
        this.exceptions = Collections.unmodifiableMap(exceptions);
    }

    public CompositeRoutingException(Map<Integer, Throwable> exceptions) {
        this(CompositeRoutingException.buildExceptionMessage(exceptions), exceptions);
    }

    public Throwable getExceptionForRouteIndex(Integer index) {
        return this.exceptions.get(index);
    }

    public Map<Integer, Throwable> getExceptions() {
        return this.exceptions;
    }

    @Override
    public String getDetailedMessage() {
        StringBuilder builder = new StringBuilder();
        builder.append(MESSAGE_TITLE).append(System.lineSeparator());
        for (Map.Entry<Integer, Throwable> entry : this.getExceptions().entrySet()) {
            String routeSubtitle = String.format("Route %d:", entry.getKey());
            MuleException muleException = ExceptionHelper.getRootMuleException(entry.getValue());
            if (muleException != null) {
                builder.append(routeSubtitle).append(muleException.getDetailedMessage());
                continue;
            }
            builder.append(routeSubtitle).append("Caught exception in Exception Strategy: " + entry.getValue().getMessage());
        }
        return builder.toString();
    }

    private static I18nMessage buildExceptionMessage(Map<Integer, Throwable> exceptions) {
        StringBuilder builder = new StringBuilder();
        for (Integer route : exceptions.keySet()) {
            Throwable routeException = exceptions.get(route);
            builder.append(System.lineSeparator() + "\t").append(route).append(": ").append(routeException.getCause() != null ? routeException.getCause().getMessage() : routeException.getMessage());
        }
        builder.insert(0, MESSAGE_TITLE);
        return I18nMessageFactory.createStaticMessage(builder.toString());
    }
}

