/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.routing.MessageSequence;
import org.mule.runtime.core.api.util.Copiable;
import org.mule.runtime.core.api.util.collection.ImmutableEntry;
import org.mule.runtime.core.api.util.collection.SplittingStrategy;
import org.mule.runtime.core.el.DefaultExpressionManager;
import org.mule.runtime.core.internal.routing.ArrayMessageSequence;
import org.mule.runtime.core.internal.routing.ExpressionSplittingStrategy;
import org.mule.runtime.core.internal.routing.outbound.CollectionMessageSequence;
import org.mule.runtime.core.internal.routing.outbound.IteratorMessageSequence;
import org.mule.runtime.core.internal.routing.outbound.NodeListMessageSequence;
import org.w3c.dom.NodeList;

public class EventToMessageSequenceSplittingStrategy
implements SplittingStrategy<Event, MessageSequence<?>> {
    private ExpressionSplittingStrategy expressionSplitterStrategy;

    public EventToMessageSequenceSplittingStrategy(ExpressionSplittingStrategy expressionSplitterStrategy) {
        this.expressionSplitterStrategy = expressionSplitterStrategy;
    }

    @Override
    public MessageSequence<?> split(Event event) {
        if (this.expressionSplitterStrategy.hasDefaultExpression()) {
            Message msg = event.getMessage();
            Object payload = msg.getPayload().getValue();
            if (payload instanceof MessageSequence) {
                return (MessageSequence)payload;
            }
            if (payload instanceof Iterator) {
                return new IteratorMessageSequence((Iterator)payload);
            }
            if (payload instanceof Collection) {
                return new CollectionMessageSequence(this.copyCollection((Collection)payload));
            }
            if (payload instanceof CursorIteratorProvider) {
                return new IteratorMessageSequence((Iterator)((CursorIteratorProvider)payload).openCursor());
            }
            if (payload instanceof Iterable) {
                return new IteratorMessageSequence(((Iterable)payload).iterator());
            }
            if (payload instanceof Object[]) {
                return new ArrayMessageSequence((Object[])payload);
            }
            if (payload instanceof NodeList) {
                return new NodeListMessageSequence((NodeList)payload);
            }
            if (payload instanceof Map) {
                LinkedList list = new LinkedList();
                Set set = ((Map)payload).entrySet();
                for (Map.Entry entry : set) {
                    list.add(new ImmutableEntry(entry));
                }
                return new CollectionMessageSequence(list);
            }
        }
        try {
            Iterator<TypedValue<?>> valueIterator = this.expressionSplitterStrategy.split(event);
            if (DefaultExpressionManager.hasMelExpression(this.expressionSplitterStrategy.getExpression())) {
                ArrayList iteratorCollection = new ArrayList();
                valueIterator.forEachRemaining(iteratorCollection::add);
                return new CollectionMessageSequence(iteratorCollection);
            }
            return new IteratorMessageSequence(valueIterator);
        }
        catch (ExpressionRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Could not split result of expression %s. The provided value is not instance of %s java type or it's not a collection in any other format", this.expressionSplitterStrategy.getExpression(), new Class[]{Iterable.class, Iterator.class, MessageSequence.class, Collection.class}), e);
        }
    }

    private Collection copyCollection(Collection payload) {
        return payload instanceof Copiable ? (Collection)((Copiable)((Object)payload)).copy() : new LinkedList(payload);
    }
}

