/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.connector.DispatchException;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.routing.RoutingException;
import org.mule.runtime.core.api.util.StringMessageUtils;
import org.mule.runtime.core.internal.routing.RoutingFailedException;
import org.mule.runtime.core.internal.routing.RoutingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirstSuccessfulRoutingStrategy
implements RoutingStrategy {
    protected static transient Logger logger = LoggerFactory.getLogger(FirstSuccessfulRoutingStrategy.class);
    private final MuleContext muleContext;
    private FlowConstruct flowConstruct;
    private String failureExpression;
    private RouteProcessor processor;

    public FirstSuccessfulRoutingStrategy(FlowConstruct flowConstruct, String failureExpression, RouteProcessor processor) {
        this.muleContext = flowConstruct.getMuleContext();
        this.flowConstruct = flowConstruct;
        this.failureExpression = failureExpression;
        this.processor = processor;
    }

    public static void validateMessageIsNotConsumable(Message message) throws MuleException {
        if (message.getPayload().getDataType().isStreamType()) {
            throw new DefaultMuleException(CoreMessages.cannotCopyStreamPayload(message.getPayload().getDataType().getType().getName()));
        }
    }

    @Override
    public Event route(Event event, List<Processor> messageProcessors) throws MuleException {
        Event returnEvent = null;
        boolean failed = true;
        Exception failExceptionCause = null;
        FirstSuccessfulRoutingStrategy.validateMessageIsNotConsumable(event.getMessage());
        for (Processor mp : messageProcessors) {
            try {
                returnEvent = this.processor.processRoute(mp, Event.builder(DefaultEventContext.child(event.getContext(), Optional.empty()), event).build());
                failed = returnEvent == null ? false : (returnEvent.getMessage() == null ? true : this.getMuleContext().getExpressionManager().evaluateBoolean(this.failureExpression, returnEvent, ((AnnotatedObject)((Object)this.flowConstruct)).getLocation(), false, true));
            }
            catch (Exception ex) {
                failed = true;
                failExceptionCause = ex;
            }
            if (failed) continue;
            break;
        }
        if (failed) {
            if (failExceptionCause != null) {
                throw new RoutingFailedException(I18nMessageFactory.createStaticMessage("All processors failed during 'first-successful' routing strategy"), failExceptionCause);
            }
            throw new RoutingFailedException(I18nMessageFactory.createStaticMessage("All processors failed during 'first-successful' routing strategy"));
        }
        return returnEvent != null ? Event.builder(event.getContext(), returnEvent).build() : null;
    }

    protected final Event sendRequest(Event routedEvent, Message message, Processor route, boolean awaitResponse) throws MuleException {
        Event result;
        try {
            result = this.sendRequestEvent(routedEvent, message, route, awaitResponse);
        }
        catch (MuleException me) {
            throw me;
        }
        catch (Exception e) {
            throw new RoutingException(null, (Throwable)e);
        }
        if (result != null) {
            Message resultMessage = result.getMessage();
            if (logger.isTraceEnabled() && resultMessage != null) {
                try {
                    logger.trace("Response payload: \n" + StringMessageUtils.truncate(this.muleContext.getTransformationService().getPayloadForLogging(resultMessage), 100, false));
                }
                catch (Exception e) {
                    logger.trace("Response payload: \n(unable to retrieve payload: " + e.getMessage());
                }
            }
        }
        return result;
    }

    private Event sendRequestEvent(Event routedEvent, Message message, Processor route, boolean awaitResponse) throws MuleException {
        if (route == null) {
            throw new DispatchException(CoreMessages.objectIsNull("route"), null);
        }
        return route.process(routedEvent);
    }

    protected MuleContext getMuleContext() {
        return this.muleContext;
    }

    static interface RouteProcessor {
        public Event processRoute(Processor var1, Event var2) throws MuleException;
    }
}

