/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.processor.AbstractMessageProcessorOwner;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.Scope;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.expression.ExpressionConfig;
import org.mule.runtime.core.internal.routing.Splitter;
import org.mule.runtime.core.internal.routing.outbound.AbstractMessageSequenceSplitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import reactor.core.publisher.Mono;

public class Foreach
extends AbstractMessageProcessorOwner
implements Initialisable,
Scope {
    public static final String ROOT_MESSAGE_PROPERTY = "rootMessage";
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<Processor> messageProcessors;
    private MessageProcessorChain ownedMessageProcessor;
    private AbstractMessageSequenceSplitter splitter;
    private String collectionExpression = "#[payload]";
    private int batchSize;
    private String rootMessageVariableName;
    private String counterVariableName;
    private boolean xpathCollection;
    private String ignoreErrorType = null;

    @Override
    public Event process(Event event) throws MuleException {
        Message transformedMessage;
        String parentMessageProp = this.rootMessageVariableName != null ? this.rootMessageVariableName : ROOT_MESSAGE_PROPERTY;
        Object previousCounterVar = null;
        Object previousRootMessageVar = null;
        if (event.getVariableNames().contains(this.counterVariableName)) {
            previousCounterVar = event.getVariable(this.counterVariableName).getValue();
        }
        if (event.getVariableNames().contains(parentMessageProp)) {
            previousRootMessageVar = event.getVariable(parentMessageProp).getValue();
        }
        Message message = event.getMessage();
        Event.Builder requestBuilder = Event.builder(event);
        boolean transformed = false;
        if (this.xpathCollection && (transformedMessage = this.transformPayloadIfNeeded(message)) != message) {
            transformed = true;
            message = transformedMessage;
            requestBuilder.message(transformedMessage);
        }
        requestBuilder.addVariable(parentMessageProp, message);
        Event.Builder responseBuilder = Event.builder(this.doProcess(requestBuilder.build()));
        if (transformed) {
            responseBuilder.message(this.transformBack(message));
        } else {
            responseBuilder.message(message);
        }
        if (previousCounterVar != null) {
            responseBuilder.addVariable(this.counterVariableName, previousCounterVar);
        } else {
            responseBuilder.removeVariable(this.counterVariableName);
        }
        if (previousRootMessageVar != null) {
            responseBuilder.addVariable(parentMessageProp, previousRootMessageVar);
        } else {
            responseBuilder.removeVariable(parentMessageProp);
        }
        return responseBuilder.build();
    }

    protected Event doProcess(Event event) throws MuleException {
        try {
            return (Event)Mono.just((Object)event).then(request -> Mono.from(MessageProcessors.processWithChildContext(request, this.ownedMessageProcessor, Optional.ofNullable(this.getLocation())))).onErrorMap(MessagingException.class, e -> {
                if (this.splitter.equals(e.getFailingMessageProcessor())) {
                    e.getInfo().remove("Element");
                    return new MessagingException(event, e.getCause(), (Processor)this);
                }
                return e;
            }).block();
        }
        catch (Throwable throwable) {
            throw Exceptions.rxExceptionToMuleException(throwable);
        }
    }

    private Message transformPayloadIfNeeded(Message message) throws TransformerException {
        Object payload = message.getPayload().getValue();
        if (payload instanceof Document || payload.getClass().getName().startsWith("org.dom4j.")) {
            return message;
        }
        return this.muleContext.getTransformationService().internalTransform(message, DataType.fromType(Document.class));
    }

    private Message transformBack(Message message) throws TransformerException {
        return this.muleContext.getTransformationService().internalTransform(message, DataType.STRING);
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return Collections.singletonList(this.ownedMessageProcessor);
    }

    public void setMessageProcessors(List<Processor> messageProcessors) throws MuleException {
        this.messageProcessors = messageProcessors;
    }

    @Override
    public void initialise() throws InitialisationException {
        ExpressionConfig expressionConfig = new ExpressionConfig();
        expressionConfig.setExpression(this.collectionExpression);
        this.splitter = new Splitter(expressionConfig, this.ignoreErrorType){

            @Override
            protected void propagateFlowVars(Event previousResult, Event.Builder builder) {
                for (String flowVarName : this.resolvePropagatedFlowVars(previousResult)) {
                    builder.addVariable(flowVarName, previousResult.getVariable(flowVarName).getValue(), previousResult.getVariable(flowVarName).getDataType());
                }
            }

            @Override
            protected Set<String> resolvePropagatedFlowVars(Event previousResult) {
                return previousResult != null ? previousResult.getVariableNames() : Collections.emptySet();
            }
        };
        if (this.isXPathExpression(expressionConfig.getExpression())) {
            this.xpathCollection = true;
        }
        this.splitter.setBatchSize(this.batchSize);
        this.splitter.setCounterVariableName(this.counterVariableName);
        this.splitter.setMuleContext(this.muleContext);
        ArrayList<Processor> chainProcessors = new ArrayList<Processor>();
        chainProcessors.add(this.splitter);
        chainProcessors.add(MessageProcessors.newChain(this.messageProcessors));
        this.ownedMessageProcessor = MessageProcessors.newChain(chainProcessors);
        super.initialise();
    }

    private boolean isXPathExpression(String expression) {
        return expression.matches("^xpath\\(.+\\)$") || expression.matches("^xpath3\\(.+\\)$");
    }

    public void setCollectionExpression(String expression) {
        this.collectionExpression = expression;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setRootMessageVariableName(String rootMessageVariableName) {
        this.rootMessageVariableName = rootMessageVariableName;
    }

    public void setCounterVariableName(String counterVariableName) {
        this.counterVariableName = counterVariableName;
    }

    public void setIgnoreErrorType(String ignoreErrorType) {
        this.ignoreErrorType = ignoreErrorType;
    }
}

