/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.ArrayList;
import java.util.List;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.message.GroupCorrelation;
import org.mule.runtime.core.api.routing.RoutingException;
import org.mule.runtime.core.internal.routing.AbstractSplitter;

public class MessageChunkSplitter
extends AbstractSplitter {
    protected int messageSize = 0;

    public int getMessageSize() {
        return this.messageSize;
    }

    public void setMessageSize(int messageSize) {
        this.messageSize = messageSize;
    }

    @Override
    protected boolean isSplitRequired(Event event) {
        return this.messageSize != 0;
    }

    @Override
    protected List<?> splitMessage(Event event) throws RoutingException {
        byte[] data;
        ArrayList<Event> messageParts = new ArrayList<Event>();
        try {
            data = event.getMessageAsBytes(this.muleContext);
        }
        catch (Exception e) {
            throw new RoutingException(CoreMessages.failedToReadPayload(), this.next, e);
        }
        Message message = event.getMessage();
        int parts = data.length / this.messageSize;
        if (parts * this.messageSize < data.length) {
            ++parts;
        }
        int len = this.messageSize;
        int pos = 0;
        for (int count = 0; count < parts; ++count) {
            if (pos + len > data.length) {
                len = data.length - pos;
            }
            byte[] buffer = new byte[len];
            System.arraycopy(data, pos, buffer, 0, buffer.length);
            pos += len;
            Event childEvent = Event.builder(event).message(Message.builder(message).payload(buffer).build()).groupCorrelation(new GroupCorrelation(parts, count)).build();
            messageParts.add(childEvent);
        }
        return messageParts;
    }
}

